(function ($) {
    $.fn.extend({
        banner: function (options) {
            options = $.extend({}, $.newBanner.defaults, options);

            this.each(function () {
                new $.newBanner($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });

    $.newBanner = function (target, options) {
        this.target = target;
        this.options = options;

        this.reposition = function () {
            if (!this.options.parallax) {
                this.target.find('.banner-inner').css({marginTop: '', marginBottom: ''});
                this.target.find('.banner-content').css({opacity: ''});
                return;
            }

            var visible = $(window).scrollTop() < this.target.height();

            if (visible) {
                this.target.find('.banner-inner').css({
                    marginTop: $(window).scrollTop() / 2,
                    marginBottom: ($(window).scrollTop() / 2) * -1
                });
            }

            if (!this.options.relativeOpacity) {
                this.target.find('.banner-content').css({opacity: ''});
                return;
            }

            var invisiblePercentage = $(window).scrollTop() / this.target.height();
            if (this.options.relativeOpacity && invisiblePercentage < 0.9) {
                var opacity = Math.max(0, 1 - (invisiblePercentage * 1.5));
                this.target.find('.banner-content').css({opacity: opacity});
            }
        };

        $(window).on('resize orientationchange scroll scrollstart touchmove', this.reposition);

        this.reposition();
    };

    // option defaults
    $.newBanner.defaults = {
        parallax: false,
        relativeOpacity: true
    };
})(jQuery);

$(function () {
    $('.banner').banner();
});