if (typeof yndenz === 'undefined') {
    var yndenz = yndenz || function () {
        return {};
    };
}

yndenz.modules = yndenz.modules || function () {
    return {};
};

yndenz.modules.banner = yndenz.modules.banner || function () {
    return {};
};

yndenz.modules.banner.banner = function (target, options) {
    this.target = target;
    this.options = options;

    jQuery(window).on('resize orientationchange scroll scrollstart touchmove', jQuery.proxy(this.reposition, this));
    this.reposition();
};

yndenz.modules.banner.banner.prototype.reposition = function () {
    if (!this.options.parallax) {
        this.target.find('.ym-banner__inner').css({marginTop: '', marginBottom: ''});
        this.target.find('.ym-banner__content').css({opacity: ''});
        return;
    }

    this.parallaxWhenVisible();
    this.setOpacity();
};

yndenz.modules.banner.banner.prototype.parallaxWhenVisible = function () {
    var visible = jQuery(window).scrollTop() < this.target.height();

    if (visible) {
        this.target.find('.ym-banner__inner').css({
            marginTop: jQuery(window).scrollTop() / 2,
            marginBottom: (jQuery(window).scrollTop() / 2) * -1
        });
    }
};

yndenz.modules.banner.banner.prototype.setOpacity = function () {
    if (!this.options.relativeOpacity) {
        this.target.find('.ym-banner__content').css({opacity: ''});
        return;
    }

    var invisiblePercentage = jQuery(window).scrollTop() / this.target.height();
    if (this.options.relativeOpacity && invisiblePercentage < 0.9) {
        var opacity = Math.max(0, 1 - (invisiblePercentage * 1.5));
        this.target.find('.ym-banner__content').css({opacity: opacity});
    }
};

yndenz.modules.banner.banner.defaults = {
    parallax: false,
    relativeOpacity: true
};

(function ($) {
    $.fn.extend({
        banner: function (options) {
            options = $.extend({}, yndenz.modules.banner.banner.defaults, options);

            this.each(function () {
                new yndenz.modules.banner.banner($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });
})(jQuery);

jQuery(function () {
    jQuery('.ym-banner').banner();
});