<?php

namespace yndenz\Modules\BaseModule;

/**
 * Class BaseModule
 * @package BaseTheme\Modules
 *
 * @method void register Register anything required for the module.
 * @method array getScripts Get scripts required for the module.
 * @method array getStyles Get stylesheets required for the module.
 */
class BaseModule {

    /**
     * BaseModule constructor.
     *
     * If register function exists, it is added to the setup_theme action.
     * If enqueue function exists, it is added to the wp_enqueue_scripts action.
     */
    public function __construct() {
        if (method_exists($this, 'register')) {
            add_action('setup_theme', array($this, 'register'));
        }
        if (method_exists($this, 'getScripts')) {
            add_filter('base_theme_basics_scripts', array($this, 'addScripts'));
        }
        if (method_exists($this, 'getStyles')) {
            add_filter('base_theme_basics_styles', array($this, 'addStyles'));
        }
    }

    /**
     * Enqueue scripts for this module using the base theme scripts filter.
     *
     * @param $scripts
     * @return array
     */
    public function addScripts($scripts) {
        $module_scripts = $this->getScripts();

        if (!is_array($module_scripts) || empty($module_scripts)) {
            return $scripts;
        }

        return array_merge($scripts, $module_scripts);
    }

}