<?php

namespace yndenz\Modules\BaseModule;

/**
 * Class BaseModule
 * @package BaseTheme\Modules
 *
 * @method void register Register anything required for the module.
 * @method static array getScripts Get scripts required for the module.
 */
class BaseModule {

    /**
     * BaseModule constructor.
     *
     * If register function exists, it is added to the setup_theme action.
     * If enqueue function exists, it is added to the wp_enqueue_scripts action.
     */
    public function __construct() {
        require_once dirname(__FILE__) . '/functions.php';

        if (method_exists($this, 'register')) {
            add_action('init', array($this, 'register'));
        }
        if (method_exists($this, 'getScripts')) {
            add_filter('base_theme_basics_scripts', array($this, 'addScripts'));
        }
    }

    /**
     * Enqueue scripts for this module using the base theme scripts filter.
     *
     * @param $scripts
     * @return array
     */
    public function addScripts($scripts) {
        $module_scripts = static::getScripts();

        if (!is_array($module_scripts) || empty($module_scripts)) {
            return $scripts;
        }

        return array_merge($scripts, $module_scripts);
    }

    public static function scripts() {
        foreach (static::getScripts() as $handle => $script) {
            if (!array_key_exists('dependencies', $script)) {
                $script['dependencies'] = array();
            }
            wp_register_script($handle, $script['src'], $script['dependencies'], false, true);
            wp_enqueue_script($handle);
        }
    }

}