<?php

namespace yndenz\Modules\BaseModule;

/**
 * Class BaseModule
 *
 * @package BaseTheme\Modules
 * @method void register Register anything required for the module.
 * @method static array getScripts Get scripts required for the module.
 */
class BaseModule {

	/**
	 * BaseModule constructor.
	 * Loads function.php in case it is not loaded before.
	 */
	public function __construct() {
		require_once dirname( __FILE__ ) . '/functions.php';
	}

	/**
	 * Initialize module.
	 * If register function exists, it is added to the init action.
	 * If enqueue function exists, it is added to the wp_enqueue_scripts action.
	 */
	public static function init() {
		require_once dirname( __FILE__ ) . '/functions.php';

		if ( property_exists( static::class, 'post_types' ) ) {
			add_action( 'init', array( static::class, 'registerPostTypes' ) );
		}

		if ( property_exists( static::class, 'taxonomies' ) ) {
			add_action( 'init', array( static::class, 'registerTaxonomies' ) );
		}

		if ( method_exists( static::class, 'register' ) ) {
			add_action( 'init', array( static::class, 'register' ) );
		}

		if ( method_exists( static::class, 'registerFields' ) ) {
			add_action( 'init', array( static::class, 'registerFields' ), 20 );
		}
	}

	public static function registerPostTypes() {
		foreach ( static::$post_types as $post_type => $args ) {
			if ( is_numeric( $post_type ) ) {
				$post_type = $args;
				$args      = array();
			}
			register_extended_post_type( $post_type, $args );
		}
	}

	public static function registerTaxonomies() {
		foreach ( static::$taxonomies as $taxonomy ) {
			register_extended_taxonomy( $taxonomy['name'], $taxonomy['post_type'] );
		}
	}

	/**
	 * Enqueue scripts for this module using the base theme scripts filter.
	 *
	 * @param $scripts
	 *
	 * @return array
	 */
	public static function addScripts( $scripts ) {
		$module_scripts = static::getScripts();

		if ( ! is_array( $module_scripts ) || empty( $module_scripts ) ) {
			return $scripts;
		}

		return array_merge( $scripts, $module_scripts );
	}

	public static function scripts() {
		foreach ( static::getScripts() as $handle => $script ) {
			if ( ! array_key_exists( 'dependencies', $script ) ) {
				$script['dependencies'] = array();
			}

			wp_enqueue_script( $handle, $script['src'], $script['dependencies'], false, true );
		}
	}

}