<?php

namespace yndenz\Modules\BaseModule;

/**
 * Class BaseModule
 *
 * @package BaseTheme\Modules
 * @method void register Register anything required for the module.
 * @method static array getScripts Get scripts required for the module.
 */
class BaseModule {

	/**
	 * BaseModule constructor.
	 * Loads function.php in case it is not loaded before.
	 */
	public function __construct() {
		require_once dirname( __FILE__ ) . '/functions.php';
	}

	/**
	 * Initialize module.
	 * If register function exists, it is added to the init action.
	 * If enqueue function exists, it is added to the wp_enqueue_scripts action.
	 */
	public static function init() {
		require_once dirname( __FILE__ ) . '/functions.php';

		if ( method_exists( static::class, 'getPostTypes' ) ) {
			add_action( 'init', array( static::class, 'registerPostTypes' ) );
		}

		if ( method_exists( static::class, 'getTaxonomies' ) ) {
			add_action( 'init', array( static::class, 'registerTaxonomies' ) );
		}

		if ( method_exists( static::class, 'register' ) ) {
			add_action( 'init', array( static::class, 'register' ) );
		}

		if ( method_exists( static::class, 'registerFields' ) ) {
			add_action( 'init', array( static::class, 'registerFields' ), 20 );
		}
	}

	/**
	 * Register custom post types.
	 * Uses the $post_types property of the class.
	 * $post_types could be either an array of post types, registering the post types with all default values.
	 * Otherwise an associative array where key is the post type and value is an array with keys args and names.
	 * For more information visit https://github.com/johnbillion/extended-cpts
	 */
	public static function registerPostTypes() {
		foreach ( static::getPostTypes() as $post_type => $details ) {
			if ( is_string( $details ) ) {
				$post_type = $details;
				$args      = array();
				$names     = array();
			} else {
				if ( array_key_exists( 'args', $details ) ) {
					$args = $details['args'];
				} else {
					$args = array();
				}
				if ( array_key_exists( 'names', $details ) ) {
					$names = $details['names'];
				} else {
					$names = array();
				}
			}
			register_extended_post_type( $post_type, $args, $names );
		}
	}

	/**
	 * Register custom taxonomies.
	 * Uses the $taxonomies property of the class.
	 * $taxonomies could be either an associative array where key is taxonomy name and value is the corresponding post type.
	 * Otherwise an associative array where key is taxonomy name and value is an associative array with keys post_type and names.
	 * For more information visit https://github.com/johnbillion/extended-cpts
	 */
	public static function registerTaxonomies() {
		foreach ( static::getTaxonomies() as $name => $details ) {
			$names = array();
			if ( is_string( $details ) ) {
				$post_type = $details;
			} else {
				$post_type = $details['post_type'];
				if ( array_key_exists( 'names', $details ) ) {
					$names = $details['names'];
				}
			}
			register_extended_taxonomy( $name, $post_type, $names );
		}
	}

	/**
	 * Enqueue scripts for this module using the base theme scripts filter.
	 *
	 * @param $scripts
	 *
	 * @return array
	 */
	public static function addScripts( $scripts ) {
		$module_scripts = static::getScripts();

		if ( ! is_array( $module_scripts ) || empty( $module_scripts ) ) {
			return $scripts;
		}

		return array_merge( $scripts, $module_scripts );
	}

	public static function scripts() {
		foreach ( static::getScripts() as $handle => $script ) {
			if ( ! array_key_exists( 'dependencies', $script ) ) {
				$script['dependencies'] = array();
			}

			wp_enqueue_script( $handle, $script['src'], $script['dependencies'], false, true );
		}
	}

}