<?php

namespace yndenz\Modules\CallToAction;

use yndenz\Modules\BaseModule\BaseModule;

class CallToAction extends BaseModule {

    protected $initialized = false;
    public $text, $title, $action, $button;

    public function __construct() {
        parent::__construct();

        add_shortcode('call_to_action', array($this, 'display'));
    }

    public function register() {
        if (!function_exists("register_field_group")) {
            return;
        }

        $location = array(
            array(
                array(
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'post',
                    'order_no' => 0,
                    'group_no' => 0,
                ),
            ),
            array(
                array(
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'page',
                    'order_no' => 0,
                    'group_no' => 1,
                ),
                array(
                    'param' => 'page_type',
                    'operator' => '!=',
                    'value' => 'front_page',
                    'order_no' => 1,
                    'group_no' => 1,
                ),
            ),
        );

        $location = apply_filters('yndenz_modules_call_to_action_field_group_location', $location);

        register_field_group(array(
            'id' => 'acf_call-to-action',
            'title' => __('Call To Action', 'base-theme'),
            'fields' => array(
                array(
                    'key' => 'acf-cta_action',
                    'label' => __('Actie', 'base-theme'),
                    'name' => 'cta_action',
                    'type' => 'select',
                    'choices' => array(
                        'contact-form' => __('Contactformulier popup', 'base-theme'),
                        'request-quickscan' => __('Quickscan aanvraag popup', 'base-theme'),
                        'link-to-page' => __('Link naar pagina', 'base-theme'),
                    ),
                    'default_value' => '',
                    'allow_null' => 1,
                    'multiple' => 0,
                ),
                array(
                    'key' => 'acf-cta_text',
                    'label' => __('Tekst', 'base-theme'),
                    'name' => 'cta_text',
                    'type' => 'text',
                    'default_value' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'formatting' => 'html',
                    'maxlength' => '',
                ),
                array(
                    'key' => 'acf-cta_title',
                    'label' => __('Titel', 'base-theme'),
                    'name' => 'cta_title',
                    'type' => 'text',
                    'default_value' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'formatting' => 'none',
                    'maxlength' => '',
                ),
                array(
                    'key' => 'acf-cta_page_id',
                    'label' => __('Pagina', 'base-theme'),
                    'name' => 'cta_page_id',
                    'type' => 'post_object',
                    'conditional_logic' => array(
                        'status' => 1,
                        'rules' => array(
                            array(
                                'field' => 'acf-cta_action',
                                'operator' => '==',
                                'value' => 'link-to-page',
                            ),
                        ),
                        'allorany' => 'all',
                    ),
                    'post_type' => array(
                        0 => 'post',
                        1 => 'page',
                    ),
                    'taxonomy' => array(
                        0 => 'all',
                    ),
                    'allow_null' => 0,
                    'multiple' => 0,
                ),
            ),
            'location' => $location,
            'options' => array(
                'position' => 'side',
                'layout' => 'default',
                'hide_on_screen' => array(),
            ),
            'menu_order' => 0,
        ));
    }

    public function initialize() {
        $this->action = apply_filters('yndenz_modules_call_to_action_action', get_post_meta(get_the_ID(), 'cta_action', true));

        if (!empty($this->action) && $this->action !== 'null') {
            $this->text = get_post_meta(get_the_ID(), 'cta_text', true);
            $this->title = get_post_meta(get_the_ID(), 'cta_title', true);

            if ($this->action === 'link-to-page') :
                $this->button = '<a href="%s" title="%s" class="btn">%s</a>';

                $cta_page_id = get_post_meta(get_the_ID(), 'cta_page_id', true);
                if ((empty($cta_page_id) || $cta_page_id === 'null') && is_single() && in_category('nieuws')) {
                    $cat = get_category_by_slug('nieuws');
                    $category_link = get_category_link($cat->term_id);
                    if (strstr($_SERVER['HTTP_REFERER'], $category_link) || preg_match('#/tag/#i', $_SERVER['HTTP_REFERER'])) {
                        $this->action = $_SERVER['HTTP_REFERER'];
                    } else {
                        $this->action = $category_link;
                    }
                    $this->text = __('Terug naar overzicht', 'base-theme');
                    $this->title = __('Terug naar overzicht | ' . get_bloginfo('name'), 'base-theme');
                } else {
                    $this->action = get_permalink($cta_page_id);
                }
            else :
                $this->button = '<button type="button" class="btn" data-toggle="modal" data-target="#%s-popup" title="%s">%s</button>';
            endif;
        }
        $this->initialized = true;
    }

    /**
     * Display the call to action.
     *
     * @return string
     */
    public function display() {
        if (!$this->initialized) {
            $this->initialize();
        }

        if (!empty($this->action) && $this->action !== 'null') {
            $template = locate_template('modules/call-to-action.php');
            if (empty($template)) {
                $template = dirname(__FILE__) . '/templates/call-to-action.php';
            }

            ob_start();
            include $template;
            return ob_get_clean();
        }
    }

}