<?php

namespace yndenz\Modules\CallToAction;

use yndenz\Modules\BaseModule\BaseModule;

class CallToAction extends BaseModule {

	protected $initialized = false;
	public $text, $title, $action, $button;

	public static function register() {
		add_shortcode('call_to_action', array(static::class, 'shortcode'));
	}

	public static function registerFields() {
		if (!function_exists("register_field_group")) {
			return;
		}

		$choices = apply_filters('yndenz_modules_call_to_action_choices', array(
			'link-to-page' => __('Link naar pagina', 'base-theme'),
			'url' => __('URL', 'base-theme')
		));

		$fields = array(
			array(
				'key' => 'acf-cta_action',
				'label' => __('Actie', 'base-theme'),
				'name' => 'cta_action',
				'type' => 'select',
				'choices' => $choices,
				'default_value' => '',
				'allow_null' => 1,
				'multiple' => 0,
			),
			array(
				'key' => 'acf-cta_text',
				'label' => __('Tekst', 'base-theme'),
				'name' => 'cta_text',
				'type' => 'text',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array(
				'key' => 'acf-cta_title',
				'label' => __('Titel', 'base-theme'),
				'name' => 'cta_title',
				'type' => 'text',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'none',
				'maxlength' => '',
			),
			array(
				'key' => 'acf-cta_page_id',
				'label' => __('Pagina', 'base-theme'),
				'name' => 'cta_page_id',
				'type' => 'post_object',
				'conditional_logic' => array(
					'status' => 1,
					'rules' => array(
						array(
							'field' => 'acf-cta_action',
							'operator' => '==',
							'value' => 'link-to-page',
						),
					),
					'allorany' => 'all',
				),
				'post_type' => array(
					0 => 'post',
					1 => 'page',
				),
				'taxonomy' => array(
					0 => 'all',
				),
				'allow_null' => 0,
				'multiple' => 0,
			),
			array(
				'key' => 'acf-cta_url',
				'label' => __('URL', 'base-theme'),
				'name' => 'cta_url',
				'type' => 'text',
				'conditional_logic' => array(
					'status' => 1,
					'rules' => array(
						array(
							'field' => 'acf-cta_action',
							'operator' => '==',
							'value' => 'url',
						),
					),
					'allorany' => 'all',
				),
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'none',
				'maxlength' => '',
			),
		);

		$fields = apply_filters('yndenz_modules_call_to_action_fields', $fields);

		$location = array(
			array(
				array(
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'post',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
			array(
				array(
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'page',
					'order_no' => 0,
					'group_no' => 1,
				),
				array(
					'param' => 'page_type',
					'operator' => '!=',
					'value' => 'front_page',
					'order_no' => 1,
					'group_no' => 1,
				),
			),
		);

		$location = apply_filters('yndenz_modules_call_to_action_locations', $location);

		register_field_group(array(
			'id' => 'acf_call-to-action',
			'title' => __('Call To Action', 'base-theme'),
			'fields' => $fields,
			'location' => $location,
			'options' => array(
				'position' => 'side',
				'layout' => 'default',
				'hide_on_screen' => array(),
			),
			'menu_order' => 0,
		));
	}

	public static function shortcode() {
		ob_start();
		(new static)->display();
		return ob_get_clean();
	}

	public function initialize() {
		$this->action = apply_filters('yndenz_modules_call_to_action_action', get_post_meta(get_the_ID(), 'cta_action', true));
		$this->button = apply_filters('yndenz_modules_call_to_action_button', '<a href="%s" title="%s" class="btn">%s</a>', $this->action);

		if (!empty($this->action) && $this->action !== 'null') {
			$this->text = get_post_meta(get_the_ID(), 'cta_text', true);
			$this->title = get_post_meta(get_the_ID(), 'cta_title', true);

			if ($this->action === 'link-to-page') {
				$cta_page_id = get_post_meta(get_the_ID(), 'cta_page_id', true);
				if ((empty($cta_page_id) || $cta_page_id === 'null') && is_single() && in_category('nieuws')) {
					$cat = get_category_by_slug('nieuws');
					$category_link = get_category_link($cat->term_id);
					if (isset($_SERVER['HTTP_REFERER']) && (strstr($_SERVER['HTTP_REFERER'], $category_link) || preg_match('#/tag/#i', $_SERVER['HTTP_REFERER']))) {
						$this->action = $_SERVER['HTTP_REFERER'];
					} else {
						$this->action = $category_link;
					}
					$this->text = __('Terug naar overzicht', 'base-theme');
					$this->title = __('Terug naar overzicht | ' . get_bloginfo('name'), 'base-theme');
				} else {
					$this->action = get_permalink($cta_page_id);
				}
			} else if ($this->action === 'url') {
				$this->action = apply_filters('yndenz_modules_call_to_action_url', get_post_meta(get_the_ID(), 'cta_url', true));
			}
		}
		$this->initialized = true;
	}

	/**
	 * Display the call to action.
	 *
	 * @return string
	 */
	public function display() {
		if (!$this->initialized) {
			$this->initialize();
		}

		if (!empty($this->action) && $this->action !== 'null') {
			$template = locate_template('modules/call-to-action.php');
			if (empty($template)) {
				$template = dirname(__FILE__) . '/templates/call-to-action.php';
			}

			include $template;
		}
	}

}