<?php

namespace yndenz\Modules\CrawlerChecker;

use WP_Query;
use yndenz\Modules\BaseModule\BaseModule;

class CrawlerChecker extends BaseModule {

	/**
	 * @return bool
	 *
	 * check a managed bot-pattern list against user agent
	 */
	public static function user_is_crawler() {
		$data = json_decode( file_get_contents( dirname( __FILE__ ) . "/crawler-user-agents.json" ), true );
		foreach ( $data as $entry ) {
			if ( isset( $_SERVER['HTTP_USER_AGENT'] ) && preg_match( '/' . $entry['pattern'] . '/', $_SERVER['HTTP_USER_AGENT'] ) ) {
				return true;
			}
		}

		return false;
	}
}