if (typeof yndenz === 'undefined') {
    var yndenz = yndenz || function () {
        return {};
    };
}

yndenz.base = yndenz.base || function () {
    return {};
};

yndenz.base.dropdown = yndenz.base.dropdown || function () {
    return {};
};

yndenz.base.dropdown.dropdownMenu = function (target, options) {
    this.target = target;
    this.options = options;
    this.dropdown = this.target.closest('.dropdown');
    this.button = this.dropdown.find('.dropdown-toggle');

    this.open = this.options.defaultOpen;

    this.watch('open', function (prop, oldVal, val) {
        if (val) {
            this.target.addClass('open');
        } else {
            this.target.removeClass('open');
        }
        return val;
    });

    this.button.on('click', jQuery.proxy(this.toggleOpen, this));
};

yndenz.base.dropdown.dropdownMenu.prototype.toggleOpen = function (e) {
    e.preventDefault();
    this.open = !this.open;
};

yndenz.base.dropdown.dropdownMenu.defaults = {
    defaultOpen: false
};

(function ($) {
    $.fn.extend({
        dropdownMenu: function (options) {
            options = $.extend({}, yndenz.base.dropdown.dropdownMenu.defaults, options);

            this.each(function () {
                new yndenz.base.dropdown.dropdownMenu($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });
})(jQuery);

jQuery(function () {
    jQuery('.dropdown-menu').dropdownMenu();
});