<?php

namespace yndenz\Modules\Dropdown;

use yndenz\Modules\BaseModule\BaseModule;

class Dropdown extends BaseModule {

	public static function register() {
		add_shortcode( 'dropdown', array( static::class, 'shortcode' ) );
	}

	/**
	 * Get the scripts used for the dropdown.
	 *
	 * @return array
	 */
	public static function getScripts() {
		return array(
			'dropdown-script' => array( 'src' => get_modules_directory_uri() . 'dropdown/dropdown.min.js' )
		);
	}

	/**
	 * Display a dropdown menu.
	 *
	 * @param string|array $atts List of attributes added to shortcode.
	 * @param string       $content
	 *
	 * @return string
	 */
	public static function shortcode( $atts = array(), $content = '' ) {
		ob_start();
		( new static )->display( $atts, $content );

		return ob_get_clean();
	}

	/**
	 * Display a dropdopwn menu.
	 *
	 * @param string|array $args List of attributes added to shortcode.
	 * @param string       $content
	 */
	public function display( $args = array(), $content = '' ) {
		if ( ! is_array( $args ) ) {
			$args = shortcode_parse_atts( $args );
		}

		if ( ! isset( $args['button-text'] ) ) {
			return;
		}

		$template = locate_template( 'modules/dropdown.php' );
		if ( empty( $template ) ) {
			$template = dirname( __FILE__ ) . '/templates/dropdown.php';
		}

		add_filter( 'base_theme_basics_scripts', array( static::class, 'addScripts' ) );

		include $template;
	}

}