<?php

namespace yndenz\Modules\Employee;

use WP_Query;
use yndenz\Modules\BaseModule\BaseModule;

class Employee extends BaseModule {

    public function register() {
        add_shortcode('specialist', array(static::class, 'display'));
        add_shortcode('list_employees', array(static::class, 'displayList'));

        $args = array(
            'labels' => array(
                'name' => __('Medewerker', 'base-theme'),
                'singular_name' => __('Medewerker', 'base-theme'),
                'menu_name' => __('Medewerkers', 'base-theme'),
                'name_admin_bar' => __('Medewerker', 'base-theme'),
                'add_new' => __('Toevoegen', 'base-theme'),
                'add_new_item' => __('Medewerker toevoegen', 'base-theme'),
                'new_item' => __('Nieuwe medewerker', 'base-theme'),
                'edit_item' => __('Bewerken', 'base-theme'),
                'view_item' => __('Bekijken', 'base-theme'),
                'all_items' => __('Alle medewerkers', 'base-theme'),
                'search_items' => __('Medewerkers zoeken', 'base-theme'),
                'not_found' => __('Geen medewerkers gevonden.', 'base-theme'),
                'not_found_in_trash' => __('Geen medewerkers gevonden in de prullenbak.', 'base-theme'),
            ),
            'description' => __('Medewerkers', 'base-theme'),
            'public' => false,
            'publicly_queryable' => false,
            'show_ui' => true,
            'show_in_menu' => true,
            'menu_position' => 20,
            'menu_icon' => 'dashicons-businessman',
            'capability_type' => 'post',
            'has_archive' => false,
            'hierarchical' => false,
            'supports' => array('title', 'editor', 'thumbnail')
        );

        $args = apply_filters('yndenz_modules_employee_post_type_args', $args);

        register_post_type('employee', $args);

        if (!function_exists("register_field_group")) {
            return;
        }

        $fields = array(
            array(
                'key' => 'acf-employee_email',
                'label' => __('E-mailadres', 'base-theme'),
                'name' => 'employee_email',
                'type' => 'text',
                'default_value' => '',
                'placeholder' => '',
                'prepend' => '',
                'append' => '',
                'formatting' => 'none',
                'maxlength' => '',
            ),
            array(
                'key' => 'acf-employee_role',
                'label' => __('Rol', 'base-theme'),
                'name' => 'employee_role',
                'type' => 'text',
                'default_value' => '',
                'placeholder' => '',
                'prepend' => '',
                'append' => '',
                'formatting' => 'html',
                'maxlength' => '',
            ),
        );

        $fields = apply_filters('yndenz_modules_employee_contact_fields', $fields);

        register_field_group(array(
            'id' => 'acf_contact-information',
            'title' => __('Contactinformatie', 'base-theme'),
            'fields' => $fields,
            'location' => array(
                array(
                    array(
                        'param' => 'post_type',
                        'operator' => '==',
                        'value' => 'employee',
                        'order_no' => 0,
                        'group_no' => 0,
                    ),
                ),
            ),
            'options' => array(
                'position' => 'acf_after_title',
                'layout' => 'default',
                'hide_on_screen' => array(),
            ),
            'menu_order' => 0,
        ));

        $locations = array(
            array(
                array(
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'post',
                    'order_no' => 0,
                    'group_no' => 0,
                ),
            ),
            array(
                array(
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'page',
                    'order_no' => 0,
                    'group_no' => 1,
                ),
                array(
                    'param' => 'page_type',
                    'operator' => '!=',
                    'value' => 'front_page',
                    'order_no' => 1,
                    'group_no' => 1,
                ),
            ),
        );

        $locations = apply_filters('yndenz_modules_employee_specialist_locations', $locations);

        register_field_group(array(
            'id' => 'acf_specialists',
            'title' => __('Specialisten', 'base-theme'),
            'fields' => array(
                array(
                    'key' => 'acf-specialists',
                    'label' => __('Medewerkers', 'base-theme'),
                    'name' => 'specialists',
                    'type' => 'post_object',
                    'instructions' => __('Selecteer één of meerdere medewerkers. Als er meerdere medewerkers geselecteerd zijn, wordt er elke keer dat iemand de pagina bezoekt willekeurig één medewerker getoond.', 'base-theme'),
                    'post_type' => array(
                        0 => 'employee',
                    ),
                    'taxonomy' => array(
                        0 => 'all',
                    ),
                    'allow_null' => 1,
                    'multiple' => 1,
                ),
                array(
                    'key' => 'acf_specialist-background-image',
                    'label' => __('Achtergrond afbeelding', 'base-theme'),
                    'name' => 'specialist_background_image',
                    'type' => 'image',
                    'save_format' => 'id',
                    'preview_size' => 'medium',
                    'library' => 'all',
                    'allow_null' => 1,
                ),
            ),
            'location' => $locations,
            'options' => array(
                'position' => 'side',
                'layout' => 'default',
                'hide_on_screen' => array(),
            ),
            'menu_order' => 0,
        ));
    }

    /**
     * Display one employee.
     *
     * @param array $atts List of attributes added to shortcode.
     * @param string $content Content in between shortcode tags.
     *
     * @return string
     */
    public function display($atts = array(), $content = '') {
        $employee_ids = get_field('specialists');
        if (is_array($employee_ids)) {
            array_walk($employee_ids, 'intval');
        }

        if (empty($employee_ids)) {
            return '';
        }

        $employees = new WP_Query(array(
            'posts_per_page' => 1,
            'ignore_sticky_posts' => true,
            'post_type' => 'employee',
            'post__in' => $employee_ids,
            'orderby' => 'rand'
        ));

        global $post;

        if (array_key_exists('template', $atts)) {
            $template = $atts['template'];
        }
        if (empty($template)) {
            $template = locate_template('modules/specialist.php');
        }
        if (empty($template)) {
            $template = dirname(__FILE__) . '/templates/specialist.php';
        }

        ob_start();

        while ($employees->have_posts()) {
            $employees->the_post();
            $employee = $post;
            include $template;
        }
        wp_reset_postdata();

        return ob_get_clean();
    }

    /**
     * Display a listing of employees.
     *
     * @param array $atts List of attributes added to shortcode.
     * @param string $content Content in between shortcode tags.
     *
     * @return string
     */
    public function displayList($atts = array(), $content = '') {
        $employees = new WP_Query(array(
            'posts_per_page' => -1,
            'ignore_sticky_posts' => true,
            'post_type' => 'employee',
            'orderby' => 'menu_order'
        ));

        if (!$employees->have_posts()) {
            return '';
        }

        if (array_key_exists('template', $atts)) {
            $template = $atts['template'];
        }
        if (empty($template)) {
            $template = locate_template('modules/specialist-list.php');
        }
        if (empty($template)) {
            $template = dirname(__FILE__) . '/templates/specialist-list.php';
        }

        ob_start();
        include $template;
        wp_reset_postdata();
        return ob_get_clean();
    }

}