<div class="ym-specialist">
    <?php if (has_post_thumbnail()) : ?>
        <div class="ym-specialist__image-wrapper">
            <?php the_post_thumbnail('medium', array('class' => 'img-responsive ym-specialist__image')); ?>
        </div>
    <?php endif; ?>
    <h3 class="ym-specialist__heading"><?php _e('Specialist', 'base-theme'); ?></h3>
    <p class="ym-specialist__name"><?php the_title(); ?></p>
    <p class="ym-specialist__role"><?php the_field('employee_role'); ?></p>
    <p class="ym-specialist__contact">
        <?php
        $email = get_field('employee_email');
        if (!empty($email)) :
            ?>
            <a href="mailto:<?php echo $email; ?>" class="ym-specialist__email"
               title="<?php printf(__('Neem contact op met %s', 'base-theme'), get_the_title($employee)); ?>">
                <i class="fa fa-envelope" aria-hidden="true"></i>
                <?php echo $email; ?>
            </a>
            <?php
        endif;

        $phone = get_field('employee_phone');
        if (!empty($phone)) :
            ?>
            <a href="tel:<?php echo apply_filters('href_phone_number', $phone); ?>" class="ym-specialist__phone"
               title="<?php printf(__('Bel %s', 'base-theme'), get_the_title($employee)); ?>">
                <i class="fa fa-phone" aria-hidden="true"></i>
                <?php echo $phone; ?>
            </a>
            <?php
        endif;
        ?>
    </p>
</div>