<div class="ym-specialist" itemprop="author" itemscope itemtype="http://schema.org/Person">
    <?php if (has_post_thumbnail($employee)) : ?>
        <div itemprop="image" itemscope itemtype="http://schema.org/ImageObject" class="ym-specialist__image-wrapper">
            <?php $metadata = wp_get_attachment_metadata(get_post_thumbnail_id($employee)); ?>
            <meta itemprop="width" content="<?php echo $metadata['width']; ?>"/>
            <meta itemprop="height" content="<?php echo $metadata['height']; ?>"/>
            <?php echo get_the_post_thumbnail($employee, 'medium', array('class' => 'img-responsive ym-specialist__image', 'itemprop' => 'url')); ?>
        </div>
    <?php endif; ?>
    <h3 class="ym-specialist__heading"><?php _e('Specialist', 'base-theme'); ?></h3>
    <p class="ym-specialist__name" itemprop="name"><?php echo get_the_title($employee); ?></p>
    <p class="ym-specialist__role" itemprop="jobTitle"><?php the_field('employee_role', $employee); ?></p>
    <p class="ym-specialist__contact">
        <?php
        $email = get_field('employee_email', $employee);
        if (!empty($email)) :
            ?>
            <a href="mailto:<?php echo $email; ?>" class="ym-specialist__email" itemprop="email"
               content="<?php echo $email; ?>"
               title="<?php printf(__('Neem contact op met %s', 'base-theme'), get_the_title($employee)); ?>">
                <i class="fa fa-envelope" aria-hidden="true"></i>
                <?php echo $email; ?>
            </a>
            <?php
        endif;

        $phone = get_field('employee_phone', $employee);
        if (!empty($phone)) :
            ?>
            <a href="tel:<?php echo apply_filters('href_phone_number', $phone); ?>" class="ym-specialist__phone"
               itemprop="phone" content="<?php echo $phone; ?>"
               title="<?php printf(__('Neem contact op met %s', 'base-theme'), get_the_title($employee)); ?>">
                <i class="fa fa-phone" aria-hidden="true"></i>
                <?php echo $phone; ?>
            </a>
            <?php
        endif;
        ?>
    </p>
</div>