<div class="ym-specialist">
	<?php if ( has_post_thumbnail( $employee ) ) : ?>
        <div class="ym-specialist__image-wrapper">
	        <?php echo get_the_post_thumbnail( $employee, 'medium', array( 'class' => 'img-responsive ym-specialist__image' ) ); ?>
        </div>
	<?php endif; ?>
    <h3 class="ym-specialist__heading"><?php _ex( 'Specialist', 'Specialist', 'base-theme' ); ?></h3>
    <p class="ym-specialist__name"><?php echo get_the_title( $employee ); ?></p>
    <p class="ym-specialist__role"><?php the_field( 'employee_role', $employee ); ?></p>
    <p class="ym-specialist__contact">
	    <?php
	    $email = get_field( 'employee_email', $employee );
	    if ( ! empty( $email ) ) :
		    ?>
            <a href="mailto:<?php echo $email; ?>" class="ym-specialist__email"
               title="<?php printf( _x( 'Neem contact op met %s', 'Specialist', 'base-theme' ), get_the_title( $employee ) ); ?>">
                <i class="fa fa-envelope" aria-hidden="true"></i>
	            <?php echo $email; ?>
            </a>
	    <?php
	    endif;

	    $phone = get_field( 'employee_phone', $employee );
	    if ( ! empty( $phone ) ) :
		    ?>
            <a href="tel:<?php echo apply_filters( 'href_phone_number', $phone ); ?>" class="ym-specialist__phone"
               title="<?php printf( _x( 'Bel %s', 'Specialist', 'base-theme' ), get_the_title( $employee ) ); ?>">
                <i class="fa fa-phone" aria-hidden="true"></i>
	            <?php echo $phone; ?>
            </a>
	    <?php
	    endif;
	    ?>
    </p>
</div>