<?php

namespace yndenz\Modules\Facebook;

use yndenz\Modules\BaseModule\BaseModule;

class FacebookPosts extends BaseModule {

	public $posts = array();
	public $limit = 10;
	protected $_page_id;
	protected $_app_id;
	protected $_app_secret;
	protected $_initialized = false;

	/**
	 * Display a listing of Facebook posts.
	 */
	public function displayList() {
		if ( ! $this->_initialized ) {
			$this->initialize();
		}

		for ( $i = 0; $i < $this->limit; $i ++ ) :
			$post = $this->posts[ $i ];
			list( $page_id, $post_id ) = explode( "_", $post->id );
			$this->display();
		endfor;
	}

	/**
	 * Initialize the Facebook Page and Facebook App settings.
	 *
	 * @param int|string|null $page_id
	 * @param int|string|null $app_id
	 * @param string|null     $app_secret
	 * @param int|null        $limit
	 */
	public function initialize( $page_id = null, $app_id = null, $app_secret = null, $limit = null ) {
		if ( ! is_null( $page_id ) ) {
			$this->_page_id = $page_id;
		} else if ( defined( 'FACEBOOK_PAGE_ID' ) ) {
			$this->_page_id = FACEBOOK_PAGE_ID;
		}
		if ( ! is_null( $app_id ) ) {
			$this->_app_id = $app_id;
		} else if ( defined( 'FACEBOOK_APP_ID' ) ) {
			$this->_app_id = FACEBOOK_APP_ID;
		}
		if ( ! is_null( $app_secret ) ) {
			$this->_app_secret = $app_secret;
		} else if ( defined( 'FACEBOOK_APP_SECRET' ) ) {
			$this->_app_secret = FACEBOOK_APP_SECRET;
		}
		if ( ! is_null( $limit ) ) {
			$this->limit = $limit;
		}

		$this->loadPosts();

		$this->_initialized = true;
	}

	/**
	 * Fetch posts from the Facebook feed.
	 */
	protected function loadPosts() {
		$url = "https://graph.facebook.com/" . $this->_page_id . "/feed";
		$url .= "?limit=" . $this->limit;
		$url .= '&access_token=' . $this->_app_id . '|' . $this->_app_secret;

		//Data reqeust
		$ch = curl_init( $url );
		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1 );
		$response = curl_exec( $ch );
		curl_close( $ch );

		$decoded_response = json_decode( $response );
		$this->posts      = $decoded_response->data;
	}

	/**
	 * Display a single Facebook post.
	 */
	public function display() {
		$template = locate_template( 'modules/facebook-post.php' );
		if ( empty( $template ) ) {
			$template = dirname( __FILE__ ) . '/templates/facebook-post.php';
		}

		include $template;
	}

	/**
	 * Display a bootstrap carousel sliding through Facebook posts.
	 */
	public function displayGallery() {
		if ( ! $this->_initialized ) {
			$this->initialize();
		}

		$template = locate_template( 'modules/facebook-gallery.php' );
		if ( empty( $template ) ) {
			$template = dirname( __FILE__ ) . '/templates/facebook-gallery.php';
		}

		include $template;
	}

}