<?php

namespace yndenz\Modules\FeaturedPages;

use WP_Post;
use WP_Query;
use yndenz\Modules\BaseModule\BaseModule;

class FeaturedPages extends BaseModule {

    public static function register() {
        add_shortcode('featured-pages', array(static::class, 'shortcode'));

        if (!function_exists('register_field_group')) {
            return;
        }

        register_field_group(array(
            'id' => 'acf_featured-pages',
            'title' => __('Uitgelichte pagina\'s', 'base-theme'),
            'fields' => array(
                array(
                    'key' => 'acf-featured_pages',
                    'label' => __('Pagina\'s', 'base-theme'),
                    'name' => 'featured_pages',
                    'type' => 'post_object',
                    'post_type' => array(
                        0 => 'page',
                    ),
                    'taxonomy' => array(
                        0 => 'all',
                    ),
                    'allow_null' => 1,
                    'multiple' => 1,
                ),
            ),
            'location' => array(
                array(
                    array(
                        'param' => 'post_type',
                        'operator' => '==',
                        'value' => 'page',
                        'order_no' => 0,
                        'group_no' => 0,
                    ),
                ),
            ),
            'options' => array(
                'position' => 'normal',
                'layout' => 'default',
                'hide_on_screen' => array(),
            ),
            'menu_order' => 0,
        ));

        register_field_group(array(
            'id' => 'acf_featured-content',
            'title' => __('Uitgelichte content', 'base-theme'),
            'fields' => array(
                array(
                    'key' => 'acf-featured_title',
                    'label' => __('Titel', 'base-theme'),
                    'name' => 'featured_title',
                    'type' => 'text',
                    'default_value' => '',
                    'formatting' => 'html',
                    'maxlength' => '',
                    'placeholder' => '',
                    'rows' => '',
                ),
                array(
                    'key' => 'acf-featured_content',
                    'label' => __('Content', 'base-theme'),
                    'name' => 'featured_content',
                    'type' => 'textarea',
                    'default_value' => '',
                    'formatting' => 'html',
                    'maxlength' => '',
                    'placeholder' => '',
                    'rows' => '',
                ),
            ),
            'location' => array(
                array(
                    array(
                        'param' => 'post_type',
                        'operator' => '==',
                        'value' => 'page',
                        'order_no' => 0,
                        'group_no' => 0,
                    ),
                    array(
                        'param' => 'page_type',
                        'operator' => '!=',
                        'value' => 'front_page',
                        'order_no' => 1,
                        'group_no' => 0,
                    ),
                ),
            ),
            'options' => array(
                'position' => 'side',
                'layout' => 'default',
                'hide_on_screen' => array(),
            ),
            'menu_order' => 0,
        ));
    }

    public static function shortcode($atts = array(), $content = '') {
        ob_start();
        (new static)->displayList($atts, $content);
        return ob_get_clean();
    }

    /**
     * Display a listing of featured pages.
     *
     * @param array|string $atts List of attributes added to shortcode.
     * @param string $content Content in between shortcode tags.
     */
    public function displayList($atts = array(), $content = '') {
        if (!is_array($atts)) {
            $atts = shortcode_parse_atts($atts);
        }

        $page_ids = get_field('featured_pages');
        if (is_array($page_ids)) {
            array_walk($page_ids, 'intval');
        }

        $page_ids = apply_filters('yndenz_modules_featured_pages_pages', $page_ids);

        if (empty($page_ids)) {
            return;
        }

        $featured_pages = new WP_Query(array(
            'post_status' => 'publish',
            'post__in' => $page_ids
        ));

        if (!$featured_pages->have_posts()) {
            return;
        }

        if (!empty($atts) && array_key_exists('template', $atts) && !empty($atts['template'])) {
            $template = $atts['template'];
        } else {
            $template = locate_template('modules/featured-pages.php');
            if (empty($template)) {
                $template = dirname(__FILE__) . '/templates/featured-pages.php';
            }
        }

        include $template;

        wp_reset_postdata();
    }

    /**
     * Display the specified featured page.
     *
     * @param WP_Post $page
     */
    public function display($page) {
        $template = locate_template('modules/featured-page.php');
        if (empty($template)) {
            $template = dirname(__FILE__) . '/templates/featured-page.php';
        }

        include $template;
    }

}