<?php

namespace yndenz\Modules\FeaturedPages;

use WP_Post;
use WP_Query;
use yndenz\Modules\BaseModule\BaseModule;

class FeaturedPages extends BaseModule {

	protected $_initialized = false;

	/**
	 * @var WP_Query
	 */
	protected $query;

	public static function register() {
		add_shortcode( 'featured-pages', array( static::class, 'shortcode' ) );
	}

	public static function registerFields() {
		if ( ! function_exists( 'acf_add_local_field_group' ) ) {
			return;
		}

		static::registerFeaturedPages();
		static::registerFeaturedContent();
	}

	public static function registerFeaturedPages() {
		$locations = array(
			array(
				array(
					'param'    => 'post_type',
					'operator' => '==',
					'value'    => 'page',
				),
			),
		);

		$locations = apply_filters( 'yndenz_modules_featured_pages_locations', $locations );

		acf_add_local_field_group( array(
			'id'       => 'group_featured_pages',
			'title'    => _x( 'Uitgelichte pagina\'s', 'Back-end pagina toevoegen/bewerken', 'base-theme' ),
			'fields'   => array(
				array(
					'key'        => 'field_featured_pages',
					'label'      => _x( 'Pagina\'s', 'Back-end pagina toevoegen/bewerken', 'base-theme' ),
					'name'       => 'featured_pages',
					'type'       => 'post_object',
					'post_type'  => array(
						0 => 'page',
					),
					'taxonomy'   => array(
						0 => 'all',
					),
					'allow_null' => 1,
					'multiple'   => 1,
				),
			),
			'location' => $locations,
			'position' => 'normal',
			'style'    => 'default',
		) );
	}

	public static function registerFeaturedContent() {
		acf_add_local_field_group( array(
			'id'       => 'group_featured_content',
			'title'    => _x( 'Uitgelichte content', 'Back-end pagina toevoegen/bewerken', 'base-theme' ),
			'fields'   => array(
				array(
					'key'        => 'field_featured_title',
					'label'      => _x( 'Titel', 'Back-end pagina toevoegen/bewerken', 'base-theme' ),
					'name'       => 'featured_title',
					'type'       => 'text',
					'formatting' => 'html',
				),
				array(
					'key'        => 'field_featured_content',
					'label'      => _x( 'Content', 'Back-end pagina toevoegen/bewerken', 'base-theme' ),
					'name'       => 'featured_content',
					'type'       => 'textarea',
					'formatting' => 'html',
				),
			),
			'location' => array(
				array(
					array(
						'param'    => 'post_type',
						'operator' => '==',
						'value'    => 'page',
					),
					array(
						'param'    => 'page_type',
						'operator' => '!=',
						'value'    => 'front_page',
					),
				),
			),
			'position' => 'side',
			'style'    => 'default',
		) );
	}

	/**
	 * Display a listing of featured pages.
	 *
	 * @param array|string $atts List of attributes added to shortcode.
	 *
	 * @return string
	 */
	public static function shortcode( $atts = array() ) {
		ob_start();
		( new static )->displayList( $atts );

		return ob_get_clean();
	}

	/**
	 * Fetch a list of featured pages.
	 *
	 * @param array $args
	 */
	public function initialize( $args = array() ) {
		$page_ids = get_field( 'featured_pages' );
		if ( is_array( $page_ids ) ) {
			array_walk( $page_ids, 'intval' );
		}

		$page_ids = apply_filters( 'yndenz_modules_featured_pages_pages', $page_ids );

		if ( empty( $page_ids ) ) {
			return;
		}

		$args = wp_parse_args( $args, array(
			'post_status' => 'publish',
			'post_type'   => 'page',
			'post__in'    => $page_ids
		) );

		$this->query = new WP_Query( $args );

		$this->_initialized = true;
	}

	/**
	 * Display a listing of featured pages.
	 *
	 * @param array|string $args List of attributes added to shortcode.
	 */
	public function displayList( $args = array() ) {
		if ( ! is_array( $args ) ) {
			$args = shortcode_parse_atts( $args );
		}

		if ( ! $this->_initialized ) {
			$this->initialize( $args );
		}

		if ( ! $this->query instanceof WP_Query || ! $this->query->have_posts() ) {
			return;
		}

		if ( ! empty( $atts ) && array_key_exists( 'template', $atts ) && ! empty( $atts['template'] ) ) {
			$template = $atts['template'];
		} else {
			$template = locate_template( 'modules/featured-pages.php' );
			if ( empty( $template ) ) {
				$template = dirname( __FILE__ ) . '/templates/featured-pages.php';
			}
		}

		include $template;
	}

	/**
	 * Display the specified featured page.
	 *
	 * @param WP_Post $page
	 */
	public function display( $page ) {
		$template = locate_template( 'modules/featured-page.php' );
		if ( empty( $template ) ) {
			$template = dirname( __FILE__ ) . '/templates/featured-page.php';
		}

		include $template;
	}

}