(function ($) {
    $.fn.extend({
        floatingLabel: function (options) {
            options = $.extend({}, $.newFloatingLabel.defaults, options);

            this.each(function () {
                new $.newFloatingLabel($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });

    $.newFloatingLabel = function (target, options) {
        this.target = target;
        this.options = options;
        this.hasFocus = false;
        this.hasInput = false;

        this.watch('hasFocus', function (prop, oldVal, val) {
            if (val) {
                this.addClass('has-focus');
            } else {
                this.removeClass('has-focus');
            }
        });

        this.checkFocus = function () {
            var formControl = this.target.find('.form-control');
            this.hasFocus = formControl && formControl.length && formControl.is(':focus').length > 0;
        };

        $(document).on('focus blur', '.form-control', $.proxy(this.checkFocus, this));

        this.watch('hasInput', function (prop, oldVal, val) {
            if (val) {
                this.addClass('has-input');
            } else {
                this.removeClass('has-input');
            }
        });

        this.checkValue = function () {
            var val = null;
            var formControl = this.target.find('.form-control');
            if (formControl && formControl.length) {
                val = formControl.val();
            }
            this.hasInput = val && val.length > 0;
        };

        this.checkValue();

        $(document).on('keydown keyup keypress change', '.form-control', $.proxy(this.checkValue, this));
    };

    // option defaults
    $.newFloatingLabel.defaults = {};
})(jQuery);

$(function () {
    $('.form-group').floatingLabel();
});