var yndenz = yndenz || function () {
    return {};
};
yndenz.modules = yndenz.modules || function () {
    return {};
};

yndenz.modules.floatingLabel = yndenz.modules.floatingLabel || function () {
    return {};
};

yndenz.modules.floatingLabel.floatingLabel = function (target, options) {
    this.target = target;
    this.options = options;
    this.hasFocus = false;
    this.hasInput = false;

    this.watch('hasFocus', function (prop, oldVal, val) {
        if (val) {
            this.target.addClass('has-focus');
        } else {
            this.target.removeClass('has-focus');
        }
    });


    jQuery(document).on('focus blur', '.form-control', jQuery.proxy(this.checkFocus, this));

    this.watch('hasInput', function (prop, oldVal, val) {
        if (val) {
            this.target.addClass('has-input');
        } else {
            this.target.removeClass('has-input');
        }
    });

    this.checkValue();

    jQuery(document).on('keydown keyup keypress change', '.form-control', jQuery.proxy(this.checkValue, this));
};

yndenz.modules.floatingLabel.floatingLabel.prototype.checkFocus = function () {
    var formControl = this.target.find('.form-control');
    this.hasFocus = formControl && formControl.length && formControl.is(':focus');
};

yndenz.modules.floatingLabel.floatingLabel.prototype.checkValue = function () {
    var val = null;
    var formControl = this.target.find('.form-control');
    if (formControl && formControl.length) {
        val = formControl.val();
    }
    this.hasInput = val && val.length > 0;
};

yndenz.modules.floatingLabel.floatingLabel.defaults = {};

(function ($) {
    $.fn.extend({
        floatingLabel: function (options) {
            options = $.extend({}, yndenz.modules.floatingLabel.floatingLabel.defaults, options);

            this.each(function () {
                new yndenz.modules.floatingLabel.floatingLabel($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });
})(jQuery);

jQuery(function () {
    jQuery('.form-group').floatingLabel();
});