if (typeof window.swipedetect !== 'function') {
    window.swipedetect = function (el, callback) {
        $.event.trigger({
            type: 'beforeSwipedetect',
            el: el,
            callback: callback
        });

        var touchsurface = el,
            swipedir,
            startX,
            startY,
            distX,
            distY,
            threshold = 150, //required min distance traveled to be considered swipe
            restraint = 100, // maximum distance allowed at the same time in perpendicular direction
            startTime,
            handleswipe = callback || function (swipedir) {
            };

        touchsurface.on('touchstart', function (e) {
            var touchobj = e.originalEvent.touches[0] || e.originalEvent.changedTouches[0];
            swipedir = 'none';
            distX = 0;
            distY = 0;
            startX = touchobj.pageX;
            startY = touchobj.pageY;
            startTime = new Date().getTime(); // record time when finger first makes contact with surface
        });

        touchsurface.on('touchend', function (e) {
            var touchobj = e.originalEvent.touches[0] || e.originalEvent.changedTouches[0];
            distX = touchobj.pageX - startX; // get horizontal dist traveled by finger while in contact with surface
            distY = touchobj.pageY - startY; // get vertical dist traveled by finger while in contact with surface
            if (Math.abs(distX) >= threshold && Math.abs(distY) <= restraint) { // 2nd condition for horizontal swipe met
                swipedir = (distX < 0) ? 'left' : 'right'; // if dist traveled is negative, it indicates left swipe
            }
            else if (Math.abs(distY) >= threshold && Math.abs(distX) <= restraint) { // 2nd condition for vertical swipe met
                swipedir = (distY < 0) ? 'up' : 'down'; // if dist traveled is negative, it indicates up swipe
            }
            handleswipe(swipedir);
        });

        $.event.trigger({
            type: 'afterSwipedetect',
            el: el,
            callback: callback
        });
    };
}

(function ($) {
    $.fn.extend({
        fullScreenGallery: function (options) {
            options = $.extend({}, $.newFullScreenGallery.defaults, options);

            this.each(function () {
                new $.newFullScreenGallery($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });

    $.newFullScreenGallery = function (target, options) {
        this.target = target;
        this.options = options;
        this.timeout = null;
        this.carousel = this.target.find('.carousel');

        this.reposition = function () {
            var sliderImages = this.target.find('.item .image-wrapper img');
            var activeImage = this.target.find('.item.active .image-wrapper img');

            if ($(window).width() >= this.options.fullScreenMinHeight) {
                this.target.css({height: $(window).height()});

                var activeImageRatio = activeImage.width() / activeImage.height();
                var containerRatio = $(window).width() / $(window).height();
                if (activeImageRatio < containerRatio) {
                    sliderImages.css({
                        height: '',
                        width: $(window).width()
                    });
                } else {
                    sliderImages.css({
                        height: this.target.height(),
                        width: ''
                    });
                }
            } else {
                this.target.css({height: ''});
                sliderImages.css({height: '', width: ''});
            }
        };

        this.reposition();
        this.timeout = setTimeout($.proxy(this.reposition, this), 1000);

        this.windowResized = function () {
            if (this.timeout) {
                clearTimeout(this.timeout);
            }

            this.reposition();
            this.timeout = setTimeout($.proxy(this.reposition, this), 700);
        };
        $(window).on('resize orientationchange', $.proxy(this.windowResized, this));

        this.navigate = function (dir) {
            if (dir === 'left') {
                this.target.carousel('prev');
            } else if (dir === 'right') {
                this.target.carousel('next');
            }
        };
        window.swipedetect(target, this.navigate);
    };

    // option defaults
    $.newFullScreenGallery.defaults = {
        fullScreenMinHeight: 992
    };
})(jQuery);

$(function () {
    $('.full-screen-gallery').fullScreenGallery();
});