<?php

namespace yndenz\Modules\Gallery;

use yndenz\Modules\BaseModule\BaseModule;

class Gallery extends BaseModule {

    public function __construct() {
        parent::__construct();

        add_filter('post_gallery', array($this, 'bootstrapGallery'), 100, 3);
    }

    /**
     * Get the scripts used for the gallery.
     *
     * @return array
     */
    protected function getScripts() {
        return array(
            'gallery-script' => array('src' => get_modules_directory_uri() . 'gallery/gallery.js')
        );
    }

    /**
     * Convert WordPress galleries into bootstrap carousels.
     *
     * @param string $output The gallery as WordPress displays it
     * @param array $atts
     *
     * @return string
     */
    public function bootstrapGallery($output, $atts) {
        if (array_key_exists('ids', $atts)) {
            $images = explode(',', $atts['ids']);

            $template = locate_template('modules/gallery.php');
            if (empty($template)) {
                $template = dirname(__FILE__) . '/templates/gallery.php';
            }

            ob_start();
            include $template;
            $output = ob_get_clean();
        }
        return $output;
    }

}