(function ($) {
    $.fn.extend({
        gallery: function (options) {
            options = $.extend({}, $.newGallery.defaults, options);

            this.each(function () {
                new $.newGallery($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });

    $.newGallery = function (target, options) {
        this.target = target;
        this.options = options;
        this.carousel = this.target.find('.carousel');

        this.navigate = function (dir) {
            if (dir === 'left') {
                this.carousel.carousel('prev');
            } else if (dir === 'right') {
                this.carousel.carousel('next');
            }
        };
        this.target.swipeDetection({callback: $.proxy(this.navigate, this)});
    };

    // option defaults
    $.newGallery.defaults = {};
})(jQuery);

$(function () {
    $('.ym-gallery').gallery();
});