(function ($) {
    $.fn.extend({
        fullScreenGallery: function (options) {
            options = $.extend({}, $.newFullScreenGallery.defaults, options);

            this.each(function () {
                new $.newFullScreenGallery($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });

    $.newFullScreenGallery = function (target, options) {
        this.target = target;
        this.options = options;
        this.timeout = null;
        this.carousel = this.target.find('.carousel');

        this.reposition = function () {
            var sliderImages = this.target.find('.item .ym-gallery__image-wrapper img');
            var activeImage = this.target.find('.item.active .ym-gallery__image-wrapper img');

            if ($(window).width() >= this.options.fullScreenMinHeight) {
                this.target.css({height: $(window).height()});

                var activeImageRatio = activeImage.width() / activeImage.height();
                var containerRatio = $(window).width() / $(window).height();
                if (activeImageRatio < containerRatio) {
                    sliderImages.css({
                        height: '',
                        width: $(window).width()
                    });
                } else {
                    sliderImages.css({
                        height: this.target.height(),
                        width: ''
                    });
                }
            } else {
                this.target.css({height: ''});
                sliderImages.css({height: '', width: ''});
            }
        };

        this.reposition();
        this.timeout = setTimeout($.proxy(this.reposition, this), 1000);

        this.windowResized = function () {
            if (this.timeout) {
                clearTimeout(this.timeout);
            }

            this.reposition();
            this.timeout = setTimeout($.proxy(this.reposition, this), 700);
        };
        $(window).on('resize orientationchange', $.proxy(this.windowResized, this));
    };

    // option defaults
    $.newFullScreenGallery.defaults = {
        fullScreenMinHeight: 992
    };
})(jQuery);

$(function () {
    $('.ym-gallery.full-screen').fullScreenGallery();
});