(function ($) {
    $.fn.extend({
        gallery: function (options) {
            options = $.extend({}, $.newGallery.defaults, options);

            this.each(function () {
                new $.newGallery($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });

    $.newGallery = function (target, options) {
        this.target = target;
        this.options = options;

        this.navigate = function (dir) {
            if (dir === 'left') {
                this.target.carousel('prev');
            } else if (dir === 'right') {
                this.target.carousel('next');
            }
        };
        this.target.swipeDetect({callback: this.navigate});
    };

    // option defaults
    $.newGallery.defaults = {};
})(jQuery);

$(function () {
    $('.ym-gallery').newGallery();
});