if (typeof yndenz === 'undefined') {
    var yndenz = yndenz || function () {
        return {};
    };
}

yndenz.modules = yndenz.modules || function () {
    return {};
};

yndenz.modules.gallery = yndenz.modules.gallery || function () {
    return {};
};

yndenz.modules.gallery.fullScreenGallery = function (target, options) {
    this.target = target;
    this.options = options;
    this.timeout = null;

    this.reposition();
    this.timeout = setTimeout(jQuery.proxy(this.reposition, this), 1000);

    jQuery(window).on('resize orientationchange', jQuery.proxy(this.windowResized, this));
};

yndenz.modules.gallery.fullScreenGallery.prototype.reposition = function () {
    if (jQuery(window).width() >= this.options.fullScreenMinHeight) {
        this.target.css({height: jQuery(window).height()});
        this.resizeSliderImages();
    } else {
        this.target.css({height: ''});
        this.target.find('.item .ym-gallery__image-wrapper img').css({height: '', width: ''});
    }
};

yndenz.modules.gallery.fullScreenGallery.prototype.resizeSliderImages = function () {
    var activeImage = this.target.find('.item.active .ym-gallery__image-wrapper img');
    var sliderImages = this.target.find('.item .ym-gallery__image-wrapper img');

    var activeImageRatio = activeImage.width() / activeImage.height();
    var containerRatio = jQuery(window).width() / jQuery(window).height();

    if (activeImageRatio < containerRatio) {
        sliderImages.css({
            height: '',
            width: jQuery(window).width()
        });
    } else {
        sliderImages.css({
            height: this.target.height(),
            width: ''
        });
    }
};

yndenz.modules.gallery.fullScreenGallery.prototype.windowResized = function () {
    if (this.timeout) {
        clearTimeout(this.timeout);
    }

    this.reposition();
    this.timeout = setTimeout(jQuery.proxy(this.reposition, this), 700);
};

yndenz.modules.gallery.fullScreenGallery.defaults = {
    fullScreenMinHeight: 992
};

(function ($) {
    $.fn.extend({
        fullScreenGallery: function (options) {
            options = $.extend({}, yndenz.modules.gallery.fullScreenGallery.defaults, options);

            this.each(function () {
                new yndenz.modules.gallery.fullScreenGallery($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });
})(jQuery);

jQuery(function () {
    jQuery('.ym-gallery.full-screen').fullScreenGallery();
});