<?php $id = sanitize_title(uniqid('gallery-', true)); ?>
<div class="ym-gallery">
    <div id="<?php echo $id; ?>" class="carousel slide<?php echo $fade ? ' carousel--fade' : ''; ?>" data-ride="carousel">
        <div class="carousel-inner" role="listbox">
            <?php for ($i = 0; $i < count($images); $i++) : ?>
                <div class="item<?php echo $i === 0 ? ' active' : ''; ?>" role="option">
                    <?php echo wp_get_attachment_image($images[$i], 'large'); ?>
                </div>
            <?php endfor; ?>
        </div>

        <div class="ym-gallery__indicators-wrapper">
            <ol class="carousel-indicators ym-gallery__carousel-indicators">
                <?php for ($i = 0; $i < count($images); $i++) : ?>
                    <li data-target="#<?php echo $id; ?>"
                        data-slide-to="<?php echo $i; ?>"<?php echo $i === 0 ? ' class="active"' : ''; ?>>
                    </li>
                <?php endfor; ?>
            </ol>
        </div>

        <a class="left carousel-control" href="#<?php echo $id; ?>" role="button" data-slide="prev">
            <span class="glyphicon glyphicon-chevron-left" aria-hidden="true"></span>
            <span class="sr-only">Previous</span>
        </a>
        <a class="right carousel-control" href="#<?php echo $id; ?>" role="button" data-slide="next">
            <span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span>
            <span class="sr-only">Next</span>
        </a>
    </div>
</div>