<?php

namespace yndenz\Modules\Gallery;

use WP_Query;
use yndenz\Modules\BaseModule\BaseModule;

class FullScreenGallery extends BaseModule {

    /**
     * Register the slide custom post type.
     */
    public static function register() {
        $args = array(
            'labels' => array(
                'name' => _x('Slides', 'Breadcrumb / Back-end menu', 'base-theme'),
                'singular_name' => _x('slide', 'Back-end slide toevoegen/bewerken', 'base-theme'),
                'add_new_item' => _x('slide toevoegen', 'Back-end slide toevoegen', 'base-theme'),
                'edit_item' => _x('Slide bewerken', 'Back-end slide bewerken', 'base-theme'),
            ),
            'description' => _x('Homepage slides', 'Back-end slide toevoegen/bewerken', 'base-theme'),
            'public' => false,
            'publicly_queryable' => false,
            'show_ui' => true,
            'show_in_menu' => true,
            'menu_position' => 20,
            'menu_icon' => 'dashicons-format-gallery',
            'capability_type' => 'post',
            'has_archive' => false,
            'hierarchical' => false,
            'supports' => array('title', 'editor', 'thumbnail')
        );

        $args = apply_filters('yndenz_modules_slide_post_type_args', $args);

        register_post_type('slide', $args);
    }

    /**
     * Get the scripts used for the full-screen gallery.
     *
     * @return array
     */
    public static function getScripts() {
        return array(
            'full-screen-gallery-script' => array('src' => get_modules_directory_uri() . 'gallery/full-screen-gallery.min.js')
        );
    }

    /**
     * Display the full-screen gallery.
     *
     * @param bool $show_indicators
     */
    public function display($show_indicators = true, $show_controls = false, $fade = true) {
        $slides = new WP_Query(array(
            'post_type' => 'slide',
            'posts_per_page' => -1,
            'orderby' => 'menu_order'
        ));

        if ($slides->have_posts()) :
            $template = locate_template('modules/full-screen-gallery.php');
            if (empty($template)) {
                $template = dirname(__FILE__) . '/templates/full-screen-gallery.php';
            }

            include $template;
        endif;
    }

    public function displaySlide($active = false) {
        $template = locate_template('modules/full-screen-gallery-slide.php');
        if (empty($template)) {
            $template = dirname(__FILE__) . '/templates/full-screen-gallery-slide.php';
        }

        include $template;
    }

}