if (typeof yndenz === 'undefined') {
    var yndenz = yndenz || function () {
        return {};
    };
}

yndenz.modules = yndenz.modules || function () {
    return {};
};

yndenz.modules.gallery = yndenz.modules.gallery || function () {
    return {};
};

yndenz.modules.gallery.gallery = function (target, options) {
    this.target = target;
    this.options = options;
    this.carousel = this.target.find('.carousel');

    this.target.swipeDetection({callback: jQuery.proxy(this.navigate, this)});

    this.carousel.on('slide.bs.carousel', jQuery.proxy(this.checkLazyLoading, this));

    setTimeout(jQuery.proxy(this.checkLazyLoading, this), 10);
    jQuery(window).on('scroll orientationchange', jQuery.proxy(this.checkLazyLoading, this));
};

yndenz.modules.gallery.gallery.prototype.navigate = function (dir) {
    if (dir === 'left') {
        this.carousel.carousel('prev');
    } else if (dir === 'right') {
        this.carousel.carousel('next');
    }
};

yndenz.modules.gallery.gallery.prototype.checkLazyLoading = function (e) {
    if (!yndenz.modules.images || typeof yndenz.modules.images.lazy !== 'function' || this.target.find('.ym-lazy').length === 0) {
        jQuery(window).unbind('scroll orientationchange', this.checkLazyLoading);
        return;
    }

    var slide;
    if (e) {
        slide = jQuery(e.relatedTarget).index();
    } else {
        slide = this.carousel.find('.item.active').index();
    }

    var slides = this.carousel.find('.item');
    var activeImage = slides.eq(slide).find('img');

    if (!yndenz.modules.images.lazy.prototype.checkImageInViewport(activeImage)) {
        return;
    }

    if (activeImage.hasClass('ym-lazy')) {
        yndenz.modules.images.lazy.prototype.loadOriginal(activeImage);
    }

    var nextSlide = slide + 1;
    if (nextSlide > this.carousel.find('.item').length) {
        nextSlide = 0;
    }
    if (nextSlide !== slide) {
        yndenz.modules.images.lazy.prototype.loadOriginal(slides.eq(nextSlide).find('img.ym-lazy'));
    }

    var prevSlide = slide - 1;
    if (prevSlide < 0) {
        prevSlide = this.carousel.find('.item').length;
    }
    if (prevSlide > 0 && prevSlide !== slide) {
        yndenz.modules.images.lazy.prototype.loadOriginal(slides.eq(prevSlide).find('img.ym-lazy'));
    }
};

yndenz.modules.gallery.gallery.defaults = {};

(function ($) {
    $.fn.extend({
        gallery: function (options) {
            options = $.extend({}, yndenz.modules.gallery.gallery.defaults, options);

            this.each(function () {
                new yndenz.modules.gallery.gallery($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });
})(jQuery);

jQuery(function () {
    jQuery('.ym-gallery').gallery();
});
