<?php

namespace yndenz\Modules\Gallery;

use yndenz\Modules\BaseModule\BaseModule;

class Gallery extends BaseModule {

	public static function register() {
		add_filter( 'post_gallery', array( static::class, 'bootstrapGallery' ), 1, 3 );
	}

	/**
	 * Convert WordPress galleries into bootstrap carousels.
	 *
	 * @param string $output The gallery as WordPress displays it
	 * @param array  $atts
	 *
	 * @return string
	 */
	public static function bootstrapGallery( $output, $atts ) {
		add_filter( 'base_theme_basics_scripts', array( static::class, 'addScripts' ) );

		if ( array_key_exists( 'ids', $atts ) ) {
			$images = explode( ',', $atts['ids'] );

			$fade = false;
			if ( array_key_exists( 'fade', $atts ) ) {
				$fade = boolval( $atts['fade'] );
			}

			$show_indicators = 'bottom';
			if ( array_key_exists( 'indicators', $atts ) ) {
				$show_indicators = $atts['indicators'] === 'false' ? false : $atts['indicators'];
			}

			$show_controls = false;
			if ( array_key_exists( 'controls', $atts ) ) {
				$show_controls = boolval( $atts['controls'] );
			}

			$template = locate_template( 'modules/gallery.php' );
			if ( empty( $template ) ) {
				$template = dirname( __FILE__ ) . '/templates/gallery.php';
			}

			ob_start();
			include $template;
			$output = ob_get_clean();
		}

		return $output;
	}

	/**
	 * Get the scripts used for the gallery.
	 *
	 * @return array
	 */
	public static function getScripts() {
		return array(
			'gallery-script' => array( 'src' => get_modules_directory_uri() . 'gallery/gallery.min.js' )
		);
	}

}