if (typeof yndenz === 'undefined') {
    var yndenz = yndenz || function () {
        return {};
    };
}

yndenz.modules = yndenz.modules || function () {
    return {};
};

yndenz.modules.gallery = yndenz.modules.gallery || function () {
    return {};
};

yndenz.modules.gallery.gallery = function (target, options) {
    this.target = target;
    this.options = options;
    this.inTransition = false;
    this.hovering = false;
    this.waitingToSlide = false;
    this.carousel = this.target.find('.ym-gallery__carousel');

    this.currentSlide = this.carousel.find('.active').index();

    this.watch('currentSlide', function (prop, oldVal, val) {
        if (this.currentSlide + 1 >= this.carousel.find('.slide').length) {
            val = 0;
        } else if (val < 0) {
            val = this.carousel.find('.slide').length - 1;
        }
        if (oldVal !== val) {
            this.slide(oldVal, val);
            this.checkLazyLoading(val);
        }
        return val;
    });

    this.watch('waitingToSlide', function (prop, oldVal, val) {
        if (oldVal && !val) {
            this.currentSlide++;
        }
        return val;
    });

    this.watch('inTransition', function (prop, oldVal, val) {
        setTimeout(jQuery.proxy(this.setTransitioningClass, this, val), 10);
        return val;
    });

    this.target.swipeDetection({callback: jQuery.proxy(this.navigate, this)});
    this.target.find('.ym-gallery__control.prev').on('click', jQuery.proxy(this.navigate, this, 'right'));
    this.target.find('.ym-gallery__control.next').on('click', jQuery.proxy(this.navigate, this, 'left'));
    this.target.find('.ym-gallery__indicators').on('click', jQuery.proxy(this.indicatorsClick, this));
    this.target.find('[data-slide-to]').on('click', jQuery.proxy(this.slideTo, this));
    this.target.on('mouseover', jQuery.proxy(this.startHovering, this));
    this.target.on('mouseout', jQuery.proxy(this.stopHovering, this));

    if (this.options.interval) {
        this.timeout = setTimeout(jQuery.proxy(this.checkInterval, this), this.options.interval);
    }

    if (this.target.hasClass('full-screen') && navigator.userAgent.match(/speed.insights|googlebot/i)) {
        this.target.find('img').css({minHeight: '768px'});
    }

    setTimeout(jQuery.proxy(this.checkLazyLoading, this), 10);
};

yndenz.modules.gallery.gallery.prototype.slide = function (from, to) {
    if (this.inTransition) {
        return;
    }

    this.inTransition = true;

    var dir = to > from ? 'left' : 'right';
    if (from === this.carousel.find('.slide').length - 1 && to === 0 && this.options.repeat) {
        dir = 'left';
    }

    this.carousel.trigger('before.slide.gallery', from, to);

    this.carousel.find('.slide').eq(to).addClass('next');

    if (!this.carousel.hasClass('fade')) {
        this.carousel.addClass(dir);
    }

    this.carousel.trigger('slide.gallery', from, to);

    setTimeout(jQuery.proxy(this.endOfTransition, this), 610);

    if (this.hasOwnProperty('timeout')) {
        clearTimeout(this.timeout);
    }

    if (this.options.interval) {
        this.timeout = setTimeout(jQuery.proxy(this.checkInterval, this), this.options.interval);
    }
};

yndenz.modules.gallery.gallery.prototype.endOfTransition = function () {
    this.carousel.trigger('after.slide.gallery');
    this.inTransition = false;
};

yndenz.modules.gallery.gallery.prototype.setTransitioningClass = function (transitioning) {
    if (transitioning) {
        this.carousel.addClass('transitioning');
    } else {
        this.carousel.removeClass('transitioning');
        this.resetCarousel();
    }
};

yndenz.modules.gallery.gallery.prototype.resetCarousel = function () {
    this.carousel.find('.slide.active').removeClass('active');
    this.carousel.find('.slide.next').removeClass('next').addClass('active');
    this.target.find('.ym-gallery__indicators li').removeClass('active').eq(this.currentSlide).addClass('active');
    this.carousel.removeClass('left right');
};

/**
 * Slide to the previous or next slide.
 *
 * @param dir Follows the direction of the movement of the slide (or swipe action), so left actually means next slide
 */
yndenz.modules.gallery.gallery.prototype.navigate = function (dir) {
    if (this.inTransition) {
        return;
    }

    if (dir === 'right') {
        this.currentSlide--;
    } else if (dir === 'left') {
        this.currentSlide++;
    }
};

/**
 * Slide to a specific slide.
 *
 * @param dir Follows the direction of the movement of the slide (or swipe action), so left actually means next slide
 */
yndenz.modules.gallery.gallery.prototype.slideTo = function (e) {
    if (this.inTransition) {
        return;
    }

    var target = jQuery(e.target);
    if (!target.is('[data-slide-to]')) {
        target = target.closest('[data-slide-to]');
    }

    this.currentSlide = parseInt(target.attr('data-slide-to'));
};

yndenz.modules.gallery.gallery.prototype.checkInterval = function () {
    if (this.hovering) {
        this.waitingToSlide = true;
    } else if (!this.inTransition) {
        this.currentSlide++;
    }
};

yndenz.modules.gallery.gallery.prototype.indicatorsClick = function (e) {
    var target = jQuery(e.target);
    if (target.is('li')) {
        this.currentSlide = jQuery(e.target).index();
    }
};

yndenz.modules.gallery.gallery.prototype.startHovering = function () {
    this.hovering = true;
};

yndenz.modules.gallery.gallery.prototype.stopHovering = function () {
    this.hovering = false;
    this.waitingToSlide = false;
};

yndenz.modules.gallery.gallery.prototype.checkLazyLoading = function (slide) {
    if (typeof yndenz.modules.images.lazy !== 'function') {
        return;
    }

    if (typeof slide === 'undefined') {
        slide = this.currentSlide;
    }

    var slides = this.carousel.find('.slide');
    yndenz.modules.images.lazy.prototype.loadOriginal(slides.eq(slide).find('img.ym-lazy'));

    var nextSlide = slide + 1;
    if (nextSlide > this.carousel.find('.slide').length) {
        nextSlide = 0;
    }
    if (nextSlide !== slide) {
        yndenz.modules.images.lazy.prototype.loadOriginal(slides.eq(nextSlide).find('img.ym-lazy'));
    }

    var prevSlide = slide - 1;
    if (prevSlide < 0) {
        prevSlide = this.carousel.find('.slide').length;
    }
    if (prevSlide > 0 && prevSlide !== slide) {
        yndenz.modules.images.lazy.prototype.loadOriginal(slides.eq(prevSlide).find('img.ym-lazy'));
    }
};

yndenz.modules.gallery.gallery.defaults = {
    interval: 8000,
    repeat: true
};

(function ($) {
    $.fn.extend({
        gallery: function (options) {
            options = $.extend({}, yndenz.modules.gallery.gallery.defaults, options);

            this.each(function () {
                new yndenz.modules.gallery.gallery($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });
})(jQuery);

jQuery(function () {
    jQuery('.ym-gallery').gallery();
});