<?php

namespace yndenz\Modules\Gallery;

use WP_Post;
use WP_Query;
use yndenz\Modules\BaseModule\BaseModule;

class FullScreenGallery extends BaseModule {

	/** @var WP_Query */
	public $query;

	protected $_initialized = false;

	public static function getPostTypes() {
		return apply_filters( 'yndenz_modules_gallery_full_screen_post_type', array(
			'slide' => array(
				'args'  => array(
					'capability_type' => 'post',
					'public'          => false,
					'show_ui'         => true,
					'menu_position'   => 20,
					'menu_icon'       => 'dashicons-format-gallery',
					'labels'          => array(
						'add_new_item' => _x( 'Slide toevoegen', 'Back-end medewerker toevoegen', 'base-theme' ),
						'edit_item'    => _x( 'Slide bewerken', 'Back-end medewerker bewerken', 'base-theme' ),
					)
				),
				'names' => array(
					'singular' => _x( 'Slide', 'Back-end medewerker toevoegen/bewerken', 'base-theme' ),
					'plural'   => _x( 'Slides', 'Breadcrumb / Back-end menu', 'base-theme' )
				)
			)
		) );
	}

	/**
	 * Get the scripts used for the gallery.
	 *
	 * @return array
	 */
	public static function getScripts() {
		return array(
			'gallery-script' => array( 'src' => get_modules_directory_uri() . 'gallery/gallery.min.js' )
		);
	}

	/**
	 * Fetch a list of slides.
	 *
	 * @param array $args
	 */
	public function initialize( $args = array() ) {
		$args = wp_parse_args( $args, array(
			'post_type'      => 'slide',
			'posts_per_page' => - 1,
			'orderby'        => 'menu_order'
		) );

		$this->query = new WP_Query( $args );

		$this->_initialized = true;
	}

	/**
	 * Display the full-screen gallery.
	 *
	 * @param string|bool $show_indicators Position of the indicators (default bottom), false if should not be
	 *                                     displayed.
	 * @param bool        $show_controls   Should controls be displayed or not.
	 * @param bool        $fade            Should the transition be fading or not (default sliding).
	 */
	public function display( $show_indicators = 'bottom', $show_controls = false, $fade = true ) {
		if ( ! $this->_initialized ) {
			$this->initialize();
		}

		if ( ! $this->query->have_posts() ) {
			return;
		}

		add_filter( 'base_theme_basics_scripts', array( static::class, 'addScripts' ) );

		$template = locate_template( 'modules/full-screen-gallery.php' );
		if ( empty( $template ) ) {
			$template = dirname( __FILE__ ) . '/templates/full-screen-gallery.php';
		}

		include $template;
	}

	/**
	 * Display the specified slide.
	 *
	 * @param WP_Post $slide
	 * @param bool    $active Should the slide be visible on load or not.
	 */
	public function displaySlide( $slide, $active = false ) {
		$template = locate_template( 'modules/full-screen-gallery-slide.php' );
		if ( empty( $template ) ) {
			$template = dirname( __FILE__ ) . '/templates/full-screen-gallery-slide.php';
		}

		include $template;
	}

}