<?php

namespace yndenz\Modules\InteractiveMap;

use yndenz\Modules\BaseModule\BaseModule;

class InteractiveMap extends BaseModule {

    public function __construct() {
        parent::__construct();

        add_shortcode('interactive_map', array($this, 'display'));
    }

    /**
     * Get the scripts used for the interactive map.
     *
     * @return array
     */
    public static function getScripts() {
        return array(
            'responsive-image-map' => array('src' => get_modules_directory_uri() . 'interactive-map/node_modules/@yuheiy/responsive-image-map/lib/index.js'),
            'interactive-map-script' => array('src' => get_modules_directory_uri() . 'interactive-map/interactive-map.js')
        );
    }

    /**
     * Display the interactive map.
     *
     * @return string
     */
    public function display()
    {
        $template = locate_template('modules/interactive-map.php');
        if (empty($template)) {
            $template = dirname(__FILE__) . '/templates/interactive-map.php';
        }

        ob_start();
        include $template;
        return ob_get_clean();
    }
}