(function ($) {
    $.fn.extend({
        interactiveMap: function (options) {
            options = $.extend({}, $.newInteractiveMap.defaults, options);

            this.each(function () {
                new $.newInteractiveMap($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });

    $.newInteractiveMap = function (target, options) {
        this.target = target;
        this.areas = target.find('area');
        this.options = options;
        this.timeout = null;

        this.target.find('.ym-interactive-map__image').imageMapResize();

        this.setImage = function (image) {
            if (!image) {
                image = this.options.defaultImage;
            }

            var img = this.target.find('> img');
            img.attr('src', img.attr('src').replace(/interactive-map\/.+\.png/i, 'interactive-map/' + image + '.png'));
        };

        this.areaHover = function (e) {
            if (this.timeout) {
                clearTimeout(this.timeout);
            }

            this.setImage($(e.target).attr('title').toLowerCase());
        };
        this.areas.on('mouseenter', $.proxy(this.areaHover, this));

        this.resetImage = function () {
            this.timeout = setTimeout($.proxy(this.setImage, this), 100);
        };
        this.areas.on('mouseout', $.proxy(this.resetImage, this));

        this.areaClick = function (e) {
            e.preventDefault();
            this.options.onclick();
        };
        this.areas.on('click', $.proxy(this.areaClick, this));
    };

    // option defaults
    $.newInteractiveMap.defaults = {
        defaultImage: 'nederland',
        onclick: function () {}
    };
})(jQuery);

$(function () {
    $('.ym-interactive-map').interactiveMap();
});