<?php

namespace yndenz\Modules\InteractiveMap;

use yndenz\Modules\BaseModule\BaseModule;

class InteractiveMap extends BaseModule {

    public static function register() {
        add_shortcode('interactive_map', array(static::class, 'shortcode'));
    }

    /**
     * Get the scripts used for the interactive map.
     *
     * @return array
     */
    public static function getScripts() {
        return array(
            'image-map-resizer' => array('src' => get_modules_directory_uri() . 'interactive-map/node_modules/image-map-resizer/js/imageMapResizer.js'),
            'interactive-map-script' => array('src' => get_modules_directory_uri() . 'interactive-map/interactive-map.js')
        );
    }

    public static function shortcode($atts = array()) {
        ob_start();
        (new static)->display($atts);
        return ob_get_clean();
    }

    /**
     * Display the interactive map.
     *
     * @param array|string $atts List of attributes added to the shortcode.
     *
     * @return string
     */
    public function display($atts = array()) {
        if (!is_array($atts)) {
            $atts = shortcode_parse_atts($atts);
        }

        $default_image = get_modules_directory_uri() . 'interactive-map/nederland.png';
        $width = 392;
        $height = 473;
        if (!empty($atts) && array_key_exists('default_image', $atts) && !empty($atts['default_image'])) {
            $default_image = $atts['default_image'];
            if (!empty($atts) && array_key_exists('width', $atts) && !empty($atts['width'])) {
                $width = $atts['width'];
                $height = $atts['height'];
            } else {
                list($width, $height,) = getimagesize($default_image);
            }
        } else if (file_exists(get_stylesheet_directory() . '/modules/interactive-map/nederland.png')) {
            $default_image = get_stylesheet_directory_uri() . '/modules/interactive-map/nederland.png';
            list($width, $height,) = getimagesize(get_stylesheet_directory() . '/modules/interactive-map/nederland.png');
        }

        $template = locate_template('modules/interactive-map.php');
        if (!empty($atts) && array_key_exists('template', $atts) && !empty($atts['template'])) {
            $template = $atts['template'];
        }
        if (empty($template)) {
            $template = dirname(__FILE__) . '/templates/interactive-map.php';
        }

        include $template;
    }
}