<?php

namespace yndenz\Modules\InteractiveMap;

use yndenz\Modules\BaseModule\BaseModule;

class InteractiveMap extends BaseModule {

	protected $_default_image;
	protected $_image_width;
	protected $_image_height;

	public static function register() {
		add_shortcode( 'interactive_map', array( static::class, 'shortcode' ) );
		add_shortcode( 'interactive-map', array( static::class, 'shortcode' ) );
	}

	/**
	 * Get the scripts used for the interactive map.
	 *
	 * @return array
	 */
	public static function getScripts() {
		return array(
			'image-map-resizer'      => array( 'src' => get_modules_directory_uri() . 'interactive-map/node_modules/image-map-resizer/js/imageMapResizer.js' ),
			'interactive-map-script' => array( 'src' => get_modules_directory_uri() . 'interactive-map/interactive-map.js' )
		);
	}

	public static function shortcode( $atts = array() ) {
		ob_start();
		( new static )->display( $atts );

		return ob_get_clean();
	}

	/**
	 * Determine default image and it's dimensions.
	 *
	 * @param $args
	 */
	public function initialize( $args ) {
		$this->_default_image = get_modules_directory_uri() . 'interactive-map/nederland.png';
		$this->_image_width   = 392;
		$this->_image_height  = 473;

		if ( ! empty( $args ) && array_key_exists( 'default_image', $args ) && ! empty( $args['default_image'] ) ) {
			$this->_default_image = $args['default_image'];

			if ( array_key_exists( 'width', $args ) && ! empty( $args['width'] ) ) {
				$this->_image_width  = $args['width'];
				$this->_image_height = $args['height'];
			} else {
				list( $this->_image_width, $this->_image_height, ) = getimagesize( $this->_default_image );
			}
		} else {
			$path = '/modules/interactive-map/nederland.png';
			if ( file_exists( get_stylesheet_directory() . $path ) ) {
				$this->_default_image = get_stylesheet_directory_uri() . $path;
				list( $this->_image_width, $this->_image_height, ) = getimagesize( get_stylesheet_directory() . $path );
			}
		}
	}

	/**
	 * Display the interactive map.
	 *
	 * @param array|string $args List of attributes added to the shortcode.
	 *
	 * @return string
	 */
	public function display( $args = array() ) {
		add_filter( 'base_theme_basics_scripts', array( static::class, 'addScripts' ) );

		if ( ! is_array( $args ) ) {
			$args = shortcode_parse_atts( $args );
		}

		$this->initialize( $args );

		$template = locate_template( 'modules/interactive-map.php' );
		if ( ! empty( $args ) && array_key_exists( 'template', $args ) && ! empty( $args['template'] ) ) {
			$template = $args['template'];
		}
		if ( empty( $template ) ) {
			$template = dirname( __FILE__ ) . '/templates/interactive-map.php';
		}

		include $template;
	}

	public function getDefaultImage() {
		return $this->_default_image;
	}

	public function getImageWidth() {
		return $this->_image_width;
	}

	public function getImageHeight() {
		return $this->_image_height;
	}
}