if (typeof yndenz === 'undefined') {
    var yndenz = yndenz || function () {
        return {};
    };
}

yndenz.modules = yndenz.modules || function () {
    return {};
};

yndenz.modules.interactiveMap = yndenz.modules.interactiveMap || function () {
    return {};
};

yndenz.modules.interactiveMap.interactiveMap = function (target, options) {
    this.target = target;
    this.areas = target.find('area');
    this.options = options;
    this.timeout = null;

    this.target.find('map').imageMapResize();

    this.areas.on('mouseenter', jQuery.proxy(this.areaHover, this));
    this.areas.on('mouseout', jQuery.proxy(this.resetImage, this));
    this.areas.on('click', jQuery.proxy(this.areaClick, this));
};

yndenz.modules.interactiveMap.interactiveMap.prototype.setImage = function (image) {
    if (!image) {
        image = this.options.defaultImage;
    }

    var img = this.target.find('> img');
    img.attr('src', img.attr('src').replace(/interactive-map\/.+\.png/i, 'interactive-map/' + image + '.png'));
};

yndenz.modules.interactiveMap.interactiveMap.prototype.areaHover = function (e) {
    if (this.timeout) {
        clearTimeout(this.timeout);
    }

    this.setImage(jQuery(e.target).attr('title').toLowerCase());
};

yndenz.modules.interactiveMap.interactiveMap.prototype.resetImage = function () {
    this.timeout = setTimeout(jQuery.proxy(this.setImage, this), 100);
};

yndenz.modules.interactiveMap.interactiveMap.prototype.areaClick = function (e) {
    e.preventDefault();
    if (typeof this.options.onclick === 'function') {
        this.options.onclick(e.target);
    } else if (typeof this.options.onclick === 'string' && window[this.options.onclick]) {
        window[this.options.onclick](e.target);
    }
};

yndenz.modules.interactiveMap.interactiveMap.defaults = {
    defaultImage: 'nederland',
    onclick: function () {
    }
};

(function ($) {
    $.fn.extend({
        interactiveMap: function (options) {
            options = $.extend({}, yndenz.modules.interactiveMap.interactiveMap.defaults, options);

            this.each(function () {
                new yndenz.modules.interactiveMap.interactiveMap($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });
})(jQuery);

jQuery(function () {
    jQuery('.ym-interactive-map').interactiveMap();
});