<?php

namespace yndenz\Modules\JSON_LD;

use yndenz\Modules\BaseModule\BaseModule;

class JSON_LD extends BaseModule {

	private $_data = array();

	public function __construct() {
		parent::__construct();

		$this->setup();
	}

	public static function init() {
		$instance = new static;

		// Filter out organisation and breadcrumb to add to WebPage or Article
		add_action( 'wpseo_json_ld_output', array( $instance, 'filterFromYoastSEO' ) );

		// Output custom JSON+LD
		add_action( 'wpseo_json_ld', array( $instance, 'output' ), 20 );
	}

	/**
	 * Schema for WebPage or Article.
	 * See https://schema.org/WebPage
	 */
	public function setup() {
		$type = 'WebPage';
		if ( is_singular( 'post' ) ) {
			$type = 'Article';
		}

		$type = apply_filters( 'yndenz_modules_json_ld_page_type', $type );

		global $post;

		$this->_data['page'] = array(
			'@context'      => 'https://schema.org',
			'@type'         => $type,
			'datePublished' => date( 'c', $post->post_date_gmt ),
			'dateModified'  => date( 'c', $post->post_modified_gmt ),
		);
	}

	/**
	 * Filter organisation and breadcrumb schema out of Yoast SEO JSON+LD to use them as property of another schema.
	 *
	 * @param $context
	 * @param $data
	 *
	 * @return array
	 */
	public function filterFromYoastSEO( $context, $data ) {
		if ( empty( $data ) ) {
			return $data;
		}

		if ( $context === 'organization_or_person' ) {
			$this->_data['page']['publisher'] = $data;

			return array();
		}

		if ( $context === 'breadcrumb' ) {
			$this->_data['page']['breadcrumb'] = $data;

			return array();
		}

		return $data;
	}

	/**
	 * Outputs the JSON LD code in a valid JSON+LD wrapper.
	 */
	private function output() {
		$this->_data = apply_filters( 'yndenz_modules_json_ld_data', $this->_data );

		foreach ( $this->_data as $context => $data ) {
			$data = apply_filters( 'yndenz_modules_json_ld_output', $data, $context );

			if ( is_array( $data ) && ! empty( $data ) ) {
				echo "<script type='application/ld+json'>", wp_json_encode( $data ), '</script>', "\n";
			}
		}
	}

}