(function ($) {
    $.fn.extend({
        dropdown: function (options) {
            options = $.extend({}, $.newDropdown.defaults, options);

            this.each(function () {
                new $.newDropdown($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });

    $.newDropdown = function (target, options) {
        this.target = target;
        this.options = options;
        this.open = this.target.hasClass('open');

        this.watch('open', function () {
            if (this.open) {
                this.target.addClass('open');
            } else {
                this.target.removeClass('open');
            }
        });

        this.toggle = function (e) {
            e.preventDefault();
            e.stopPropagation();
            this.open = !this.open;
        };
        this.target.parent().find('.dropdown-toggle').on('click', this.toggle);

        this.mouseenter = function () {
            if (this.options.openOnHover) {
                this.open = true;
            }
        };
        this.target.parent().on('mouseenter', this.mouseenter);

        this.mouseleave = function () {
            if (this.options.openOnHover) {
                this.open = false;
            }
        };
        this.target.parent().on('mouseleave', this.mouseleave);
    };

    // option defaults
    $.newDropdown.defaults = {
        openOnHover: false
    };
})(jQuery);

$(function () {
    $('.dropdown-submenu').dropdown({openOnHover: false});
    $('.dropdown-menu').dropdown({openOnHover: true});
});