(function ($) {
    $.fn.extend({
        navbar: function (options) {
            options = $.extend({}, $.newNavbar.defaults, options);

            this.each(function () {
                new $.newNavbar($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });

    $.newNavbar = function (target, options) {
        this.target = target;
        this.options = options;
        this.lastScrollTop = 0;
        this.minify = false;
        this.height = target.height();
        this.breakPoint = options.breakPoint;

        this.watch('minify', function (prop, oldVal, val) {
            if (oldVal !== val) {
                if (val) {
                    this.target.addClass('minify');
                } else {
                    this.target.removeClass('minify');
                }
            }
        });

        this.defineBreakPoint = function () {
            if ($('.ybt-content').length) {
                this.breakPoint = $('.ybt-content').offset().top - this.height;
            } else if ($('.ym-banner').length) {
                this.breakPoint = $('.ym-banner').outerHeight(true) - this.height;
            } else if ($('.ym-gallery.full-screen').length) {
                this.breakPoint = $('.ym-gallery.full-screen').outerHeight(true) - this.height;
            } else if (this.options.breakPointElement) {
                this.breakPoint = this.options.breakPointElement.offset().top - this.height;
            }
            this.minify = this.lastScrollTop > this.breakPoint;
        };

        this.redefineBreakPoint = function () {
            this.defineBreakPoint();
            setTimeout($.proxy(this.defineBreakPoint, this), 1000);
        };

        this.redefineBreakPoint();
        $(window).on('resize orientationchange', $.proxy(this.redefineBreakPoint, this));

        this.windowScroll = function () {
            var scrollTop = $(window).scrollTop();

            if (scrollTop === this.lastScrollTop) {
                return;
            }

            this.minify = scrollTop > this.breakPoint;

            this.lastScrollTop = scrollTop;
        };
        $(window).on('scroll scrollstart touchmove', $.proxy(this.windowScroll, this));

        setInterval(this.windowScroll, 100);
    };

    // option defaults
    $.newNavbar.defaults = {
        breakPoint: 1,
        breakPointElement: null
    };
})(jQuery);

$(function () {
    $('.ym-navbar').navbar();
});