<?php

namespace yndenz\Modules\Navigation;

use yndenz\Modules\BaseModule\BaseModule;

class Navbar extends BaseModule {

    /**
     * Get the scripts used for the banner.
     *
     * @return array
     */
    public static function getScripts() {
        return array(
            'navbar-script' => array('src' => get_modules_directory_uri() . 'navigation/navbar.js'),
            'dropdown-script' => array('src' => get_modules_directory_uri() . 'navigation/dropdown.js')
        );
    }

    public function display() {
        $template = locate_template('modules/navbar.php');
        if (empty($template)) {
            $template = dirname(__FILE__) . '/templates/navbar.php';
        }

        include $template;
    }

}