(function ($) {
    $.fn.extend({
        dropdown: function (options) {
            options = $.extend({}, $.newDropdown.defaults, options);

            this.each(function () {
                new $.newDropdown($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });

    $.newDropdown = function (target, options) {
        this.target = target;
        this.options = options;
        this.open = this.target.hasClass('open');
        this.timeout = null;

        this.watch('open', function (prop, oldVal, val) {
            if (oldVal !== val) {
                if (val) {
                    this.target.addClass('open');
                } else {
                    this.target.removeClass('open');
                }
            }

            return val;
        });

        this.toggle = function (e) {
            e.preventDefault();
            e.stopPropagation();
            if (this.timeout) {
                clearTimeout(this.timeout);
            }
            this.open = !this.open;
        };
        this.target.parent().find('> .dropdown-toggle, > .submenu-toggle').on('click', $.proxy(this.toggle, this));

        this.mouseenter = function () {
            if (this.options.openOnHover && $(window).width() >= window.gridFloatBreakpoint) {
                this.timeout = setTimeout($.proxy(this.setOpened, this), 10);
            }
        };
        this.setOpened = function () {
            this.open = true;
        };
        this.target.parent().on('mouseenter', $.proxy(this.mouseenter, this));

        this.mouseleave = function () {
            if (this.options.openOnHover && $(window).width() >= window.gridFloatBreakpoint) {
                this.timeout = setTimeout($.proxy(this.setClosed, this), 10);
            }
        };
        this.setClosed = function () {
            this.open = false;
        };
        this.target.parent().on('mouseleave', $.proxy(this.mouseleave, this));
    };

    // option defaults
    $.newDropdown.defaults = {
        openOnHover: false
    };
})(jQuery);

$(function () {
    $('.dropdown-submenu').dropdown({openOnHover: false});
    $('.dropdown-menu').dropdown({openOnHover: true});
});