let yndenz = yndenz || {};
yndenz.modules = yndenz.modules || {};

yndenz.modules.navigation = yndenz.modules.navigation || {};

yndenz.modules.navigation.navbar = function (target, options) {
    this.target = target;
    this.options = options;
    this.minify = false;
    this.menuToggleButton = this.target.find('.navbar-toggle');

    this.watch('minify', function (prop, oldVal, val) {
        if (oldVal !== val) {
            if (val) {
                this.target.addClass('minify');
            } else {
                this.target.removeClass('minify');
            }
        }

        return val;
    });

    this.redefineBreakPoint();
    $(window).on('resize orientationchange', $.proxy(this.redefineBreakPoint, this));
    $(window).on('scroll scrollstart touchmove', $.proxy(this.windowScroll, this));

    this.menuToggleButton.on('click', $.proxy(this.toggleMenu, this));

    setInterval(this.windowScroll, 100);
};

yndenz.modules.navigation.navbar.prototype.defineBreakPoint = function () {
    if (typeof this.options.defineBreakPoint === 'function') {
        this.breakPoint = this.options.defineBreakPoint(this.target);
    } else if (typeof this.options.defineBreakPoint === 'string' && window[this.options.defineBreakPoint]) {
        this.breakPoint = window[this.options.defineBreakPoint](this.target);
    } else {
        this.breakPoint = $.newNavbar.defaults.defineBreakPoint(this.target);
    }
    this.breakPoint = Math.max(1, this.breakPoint);
    this.minify = this.lastScrollTop > this.breakPoint;
};

yndenz.modules.navigation.navbar.prototype.redefineBreakPoint = function () {
    this.defineBreakPoint();
    setTimeout($.proxy(this.defineBreakPoint, this), 1000);
};

yndenz.modules.navigation.navbar.prototype.windowScroll = function () {
    let scrollTop = $(window).scrollTop();

    if (scrollTop === this.lastScrollTop) {
        return;
    }

    this.minify = scrollTop > this.breakPoint;

    this.lastScrollTop = scrollTop;
};

yndenz.modules.navigation.navbar.prototype.toggleMenu = function () {
    if (this.menuToggleButton.hasClass('collapsed')) {
        this.target.addClass('menu-opened');
    } else {
        this.target.removeClass('menu-opened');
    }
};

// option defaults
yndenz.modules.navigation.navbar.defaults = {
    defineBreakPoint: (target) => {
        if ($('.ybt-content').length) {
            return $('.ybt-content').offset().top - target.height();
        } else if ($('.ym-banner').length) {
            return $('.ym-banner').outerHeight(true) - target.height();
        } else if ($('.ym-gallery.full-screen').length) {
            return $('.ym-gallery.full-screen').outerHeight(true) - target.height();
        }
        return 1;
    }
};

(function ($) {
    $.fn.extend({
        navbar: function (options) {
            options = $.extend({}, yndenz.modules.navigation.navbar.defaults, options);

            this.each(function () {
                new yndenz.modules.navigation.navbar($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });
})(jQuery);

jQuery(function () {
    $('.ym-navbar').navbar();
});