<?php

namespace yndenz\Modules\Navigation;

use yndenz\Modules\BaseModule\BaseModule;

class AttentionBar extends BaseModule {

    public static function register() {
        add_shortcode('attention-bar', array(static::class, 'shortcode'));
        add_filter('optionsframework_options_filter', array(static::class, 'options'));
    }

    public static function options($options) {
        $options[] = array('name' => __('Attentiebalk', 'base-theme'),
            'type' => 'heading');
        $options['attention_bar_display'] = array(
            'name' => __('Attentiebalk tonen', 'base-theme'),
            'desc' => __('Deze attentiebalk hangt bij de meeste thema\'s onder het menu aan de navigatie balk.', 'base-theme'),
            'id' => 'alert_bar_display',
            'std' => '1',
            'type' => 'checkbox');
        $options['attention_bar_content'] = array(
            'name' => __('Tekst', 'base-theme'),
            'id' => 'attention_bar_content',
            'desc' => __('Het gebruik van HTML is toegestaan, maar kan voor (weergave) problemen zorgen.', 'base-theme'),
            'std' => '',
            'type' => 'textarea');
        return $options;
    }

    public static function shortcode() {
        ob_start();
        (new static)->display();
        return ob_get_clean();
    }

    public function display() {
        if (!of_get_option('alert_bar_display', false)) {
            return;
        }

        $content = of_get_option('attention_bar_content');
        if (empty($content)) {
            return;
        }

        $template = locate_template('modules/attention-bar.php');
        if (empty($template)) {
            $template = dirname(__FILE__) . '/templates/attention-bar.php';
        }

        include $template;
    }

}