if (typeof yndenz === 'undefined') {
    var yndenz = yndenz || function () {
        return {};
    };
}

yndenz.modules = yndenz.modules || function () {
    return {};
};

yndenz.modules.navigation = yndenz.modules.navigation || function () {
    return {};
};

yndenz.modules.navigation.dropdown = function (target, options) {
    this.target = target;
    this.options = options;
    this.timeout = null;

    if (typeof this.options.checkDefaultOpen === 'function') {
        this.open = this.options.checkDefaultOpen(this.target);
    } else if (typeof this.options.checkDefaultOpen === 'string' && window[this.options.checkDefaultOpen]) {
        this.open = window[this.options.checkDefaultOpen](this.target);
    } else {
        this.open = yndenz.modules.navigation.dropdown.defaults.checkDefaultOpen(this.target);
    }

    this.watch('open', function (prop, oldVal, val) {
        if (oldVal !== val) {
            if (val) {
                this.target.addClass('open');
            } else {
                this.target.removeClass('open');
            }
        }

        return val;
    });

    this.target.parent().find('> .dropdown-toggle, > .submenu-toggle').on('click', jQuery.proxy(this.toggle, this));
    jQuery(document).on('click', jQuery.proxy(this.checkToggle, this));
    this.target.parent().on('mouseenter', jQuery.proxy(this.mouseenter, this));
    this.target.parent().on('mouseleave', jQuery.proxy(this.mouseleave, this));
};

yndenz.modules.navigation.dropdown.prototype.toggle = function (e) {
    e.preventDefault();
    if (this.timeout) {
        clearTimeout(this.timeout);
    }
    this.open = !this.open;
};

yndenz.modules.navigation.dropdown.prototype.checkToggle = function (e) {
    if (this.options.closeSiblings && !this.target.parent().is(e.target) && this.target.parent().find(e.target).length <= 0) {
        if (this.timeout) {
            clearTimeout(this.timeout);
        }
        this.setClosed();
    }
};

yndenz.modules.navigation.dropdown.prototype.setOpened = function () {
    this.open = true;
};

yndenz.modules.navigation.dropdown.prototype.setClosed = function () {
    this.open = false;
};

yndenz.modules.navigation.dropdown.prototype.mouseenter = function () {
    if (this.options.openOnHover && jQuery(window).width() >= window.gridFloatBreakpoint) {
        this.timeout = setTimeout(jQuery.proxy(this.setOpened, this), 10);
    }
};

yndenz.modules.navigation.dropdown.prototype.mouseleave = function () {
    if (this.options.openOnHover && jQuery(window).width() >= window.gridFloatBreakpoint) {
        this.timeout = setTimeout(jQuery.proxy(this.setClosed, this), 10);
    }
};

yndenz.modules.navigation.dropdown.defaults = {
    openOnHover: false,
    closeSiblings: false,
    checkDefaultOpen: function (target) {
        return target.hasClass('open');
    }
};

(function ($) {
    $.fn.extend({
        dropdown: function (options) {
            options = $.extend({}, yndenz.modules.navigation.dropdown.defaults, options);

            this.each(function () {
                new yndenz.modules.navigation.dropdown($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });
})(jQuery);

jQuery(function () {
    jQuery('.dropdown-submenu').dropdown({openOnHover: false});
    jQuery('.dropdown-menu').dropdown({openOnHover: true});
});