<?php

namespace yndenz\Modules\Navigation;

use stdClass;
use yndenz\Modules\BaseModule\BaseModule;

class Navbar extends BaseModule {

    /**
     * Get the scripts used for the banner.
     *
     * @return array
     */
    public static function getScripts() {
        return apply_filters('yndenz_modules_navigation_scripts', array(
            'navbar-script' => array('src' => get_modules_directory_uri() . 'navigation/navbar.min.js'),
            'dropdown-script' => array('src' => get_modules_directory_uri() . 'navigation/dropdown.min.js')
        ));
    }

    public function display() {
        $template = locate_template('modules/navbar.php');
        if (empty($template)) {
            $template = dirname(__FILE__) . '/templates/navbar.php';
        }

        include $template;
    }

    public static function includeSearch($in_menu = false) {
        if ($in_menu) {
            add_filter('wp_nav_menu_items', array(static::class, 'addSearchForm'), 10, 2);
        } else {
            add_filter('yndenz_modules_navigation_search', '__return_true');
        }

        add_filter('yndenz_modules_navigation_scripts', function ($scripts) {
            $scripts['navigation-search-script'] = array('src' => get_modules_directory_uri() . 'navigation/search.min.js');
            return $scripts;
        });
    }

    /**
     * Add search form to menu.
     *
     * @param string $items
     * @param stdClass $args
     * @return string
     */
    public static function addSearchForm($items, $args) {
        if ($args->theme_location == 'navbar') {
            global $in_menu;
            $in_menu = true;
            $items .= sprintf('<li class="ym-navbar__search">%s</li>', get_search_form(false));
            $in_menu = false;
            return $items;
        }
        return $items;
    }

}