<?php

namespace yndenz\Modules\Navigation;

use stdClass;
use WP_Post;

class NavPure extends NavNonClickables {

	/**
	 * Add dropdown attributes to the menu.
	 *
	 * @see   Walker::start_lvl()
	 * @since 3.0.0
	 *
	 * @param string $output Passed by reference. Used to append additional content.
	 * @param int    $depth  Depth of page. Used for padding.
	 * @param array  $args
	 */
	public function start_lvl( &$output, $depth = 0, $args = array() ) {
		$indent = str_repeat( "\t", $depth );

		$id = '';
		if ( isset( $args->dropdown_id ) && $args->dropdown_id ) {
			$id = ' id="' . $args->dropdown_id . '"';
		}

		$output .= "\n" . $indent . '<ul role="menu" class="pure-menu-children"' . $id . ">\n";
	}

	/**
	 * Add dropdown classes to the item.
	 *
	 * @param WP_Post  $item
	 * @param int      $depth Depth of menu item. Used for padding.
	 * @param stdClass $args
	 *
	 * @return array
	 */
	protected function item_get_classes( $item, $depth, $args ) {
		if ( empty( $item->classes ) ) {
			$item->classes = array();
		}

		if ( ! is_array( $item->classes ) ) {
			$item->classes = (array) $item->classes;
		}

		array_push( $item->classes, 'pure-menu-item' );

		if ( $args->has_children ) {
			array_push( $item->classes, 'pure-menu-has-children pure-menu-allow-hover' );
		}

		if ( $item->current || $item->current_item_ancestor || $item->current_item_parent ) {
			array_push( $item->classes, 'pure-menu-selected' );
		}

		return parent::item_get_classes( $item, $depth, $args );
	}

	/**
	 * Add dropdown caret to the anchor.
	 *
	 * @param WP_Post  $item  Menu item data object.
	 * @param int      $depth Depth of menu item. Used for padding.
	 * @param stdClass $args  An object of wp_nav_menu() arguments.
	 *
	 * @return string
	 */
	protected function build_anchor( $item, $depth, $args ) {
		if ( $args->has_children ) {
			if ( $depth > 0 ) {
				$dropdown_toggle_atts = ' class="ym-navbar__submenu-toggle"';
			} else {
				$dropdown_toggle_atts = ' class="ym-navbar__dropdown-toggle"';
			}

			if ( ! property_exists( $item, 'link_extra_after' ) ) {
				$item->link_extra_after = '';
			}

			$item->link_extra_after .= '</a> <a title="' . $item->attr_title . '" href="#"' . $dropdown_toggle_atts . '>';
		}

		return parent::build_anchor( $item, $depth, $args );
	}

	protected function get_anchor_attributes( $item, $depth, $args ) {
		$attributes = parent::get_anchor_attributes( $item, $depth, $args );
		$attributes .= ' class="pure-menu-link"';

		return $attributes;
	}

}