if (typeof yndenz === 'undefined') {
    var yndenz = yndenz || function () {
        return {};
    };
}

yndenz.modules = yndenz.modules || {};

yndenz.modules.navigation = yndenz.modules.navigation || {};

yndenz.modules.navigation.dropdown = function (target, options) {
    this.target = target;
    this.options = options;
    this.open = this.options.defaultOpen;
    this.menu = this.target.find('.pure-menu-children');

    this.watch('open', function (prop, oldVal, val) {
        if (oldVal !== val) {
            if (val) {
                this.menu.addClass('open');
            } else {
                this.menu.removeClass('open');
            }
        }

        return val;
    });

    this.target.find('.ym-navbar__dropdown-toggle').on('click', jQuery.proxy(this.toggleOpen, this));
    this.target.on('mouseover', jQuery.proxy(this.doOpen, this));
    this.target.on('mouseout', jQuery.proxy(this.undoOpen, this));
};

yndenz.modules.navigation.dropdown.prototype.toggleOpen = function () {
    this.open = !this.open;
};

yndenz.modules.navigation.dropdown.prototype.doOpen = function () {
    this.open = true;
};

yndenz.modules.navigation.dropdown.prototype.undoOpen = function () {
    this.open = false;
};

// option defaults
yndenz.modules.navigation.dropdown.defaults = {
    defaultOpen: false
};

(function ($) {
    $.fn.extend({
        dropdown: function (options) {
            options = $.extend({}, yndenz.modules.navigation.dropdown.defaults, options);

            this.each(function () {
                new yndenz.modules.navigation.dropdown($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });
})(jQuery);

jQuery(function () {
    jQuery('.ym-navbar__menu .pure-menu-has-children').dropdown();
});