<nav class="ym-navbar">
    <div class="container">
        <div class="ym-navbar__header">
	        <?php $homepage_seo_title = get_seo_title( get_post( get_option( 'page_on_front' ) ) ); ?>
            <a class="ym-navbar__logo" href="<?php echo esc_url( home_url( '/' ) ); ?>"
               title="<?php echo $homepage_seo_title; ?>">
		        <?php echo get_company_logo( 'medium', $homepage_seo_title ); ?>
            </a>
            <a class="pure-visible-xs ym-navbar__mobile-button ym-navbar__phone-number"
               href="tel:<?php echo preg_replace( '/[^\d\+]+/i', '', preg_replace( '/\(.+\)/i', '', of_get_option( 'phone' ) ) ); ?>"
               title="<?php printf( _x( 'Bel %s', 'Navbar', 'base-theme' ), get_bloginfo( 'name' ) ); ?>">
                <i class="fa fa-phone"></i>
                <span class="sr-only"><?php echo of_get_option( 'phone' ); ?></span>
            </a>
            <a class="pure-visible-xs ym-navbar__mobile-button ym-navbar__email"
               href="mailto:<?php echo get_option( 'admin_email' ); ?>"
               title="<?php printf( _x( 'Email %s', 'Navbar', 'base-theme' ), get_bloginfo( 'name' ) ); ?>">
                <i class="fa fa-envelope"></i>
                <span class="sr-only"><?php echo get_option( 'admin_email' ); ?></span>
            </a>
            <a class="pure-visible-xs ym-navbar__mobile-button ym-navbar__search-button"
               href="<?php echo home_url( '/' ); ?>?s="
               title="<?php _ex( 'Zoeken', 'Navbar', 'base-theme' ); ?>">
                <i class="fa fa-search"></i>
                <span class="sr-only"><?php _ex( 'Zoeken', 'Navbar', 'base-theme' ); ?></span>
            </a>
            <button type="button" class="ym-navbar__mobile-button ym-navbar__toggle-menu">
                <i class="fa fa-bars" aria-hidden="true"></i>
                <span class="sr-only"><?php _ex( 'Open het menu', 'Navbar', 'base-theme' ); ?></span>
            </button>
        </div>
        <div class="ym-navbar__addition pure-hidden-xs">
            <a href="mailto:<?php echo get_option( 'admin_email' ); ?>"
               title="<?php printf( _x( 'Email %s', 'Navbar', 'base-theme' ), get_bloginfo( 'name' ) ); ?>">
                <i class="fa fa-envelope"></i>
		        <?php echo get_option( 'admin_email' ); ?>
            </a>
            <a href="tel:<?php echo preg_replace( '/[^\d\+]+/i', '', preg_replace( '/\(.+\)/i', '', of_get_option( 'phone' ) ) ); ?>"
               title="<?php printf( _x( 'Bel %s', 'Navbar', 'base-theme' ), get_bloginfo( 'name' ) ); ?>">
                <i class="fa fa-phone"></i>
		        <?php echo of_get_option( 'phone' ); ?>
            </a>
        </div>
	    <?php
	    if ( shortcode_exists( 'attention-bar' ) ) :
		    echo do_shortcode( '[attention-bar]' );
	    endif;

	    $display_search = apply_filters( 'yndenz_modules_navigation_search', false );
	    if ( $display_search ) :
		    printf( '<div class="ym-navbar__search">%s</div>', get_search_form( false ) );
	    endif;

	    wp_nav_menu( array(
		    'theme_location'  => 'navbar',
		    'container'       => 'div',
		    'container_class' => 'ym-navbar__menu pure-menu pure-menu-horizontal',
		    'container_id'    => 'ym-navbar__menu',
		    'menu_class'      => 'pure-menu-list',
		    'fallback_cb'     => 'wp_bootstrap_navwalker::fallback',
		    'walker'          => new \yndenz\Modules\Navigation\NavPure()
	    ) );
	    ?>
    </div>
</nav>