if (typeof yndenz === 'undefined') {
    var yndenz = function () {
        return {};
    };
}

yndenz.modules = yndenz.modules || function () {
    return {};
};

yndenz.modules.navigation = yndenz.modules.navigation || function () {
    return {};
};

yndenz.modules.navigation.search = function (target, options) {
    this.target = target;
    this.options = options;
    this.button = this.target.find('.pure-button');
    this.input = this.target.find('.form-control');
    this.show = false;

    this.watch('show', function (prop, oldVal, val) {
        if (val) {
            this.target.addClass('show');
        } else {
            this.target.removeClass('show');
        }

        return val;
    });

    this.button.on('click', jQuery.proxy(this.checkShow, this));
    jQuery('.ym-navbar .toggle-search').on('click', jQuery.proxy(this.checkShow, this));

    jQuery(document).on('click', jQuery.proxy(this.documentClick, this));
};

yndenz.modules.navigation.search.prototype.documentClick = function (e) {
    if (jQuery(e.target).is('.ym-navbar__search') || jQuery(e.target).closest('.ym-navbar__search').length) {
        return;
    }

    if (jQuery(e.target).is('.ym-navbar .toggle-search') || jQuery(e.target).closest('.ym-navbar .toggle-search').length) {
        return;
    }

    this.show = false;
};

yndenz.modules.navigation.search.prototype.checkShow = function (e) {
    if (!this.options.mobileCheckEmpty && jQuery(window).width() < window.gridFloatBreakpoint) {
        if (this.input.val().length <= 0) {
            e.preventDefault();
        }
    } else {
        if (!this.show) {
            e.preventDefault();
            this.show = true;
        } else if (this.input.val().length <= 0) {
            e.preventDefault();
            this.show = false;
        }
    }
};

yndenz.modules.navigation.search.defaults = {
    mobileCheckEmpty: true
};

(function ($) {
    $.fn.extend({
        navigationSearch: function (options) {
            options = $.extend({}, yndenz.modules.navigation.search.defaults, options);

            this.each(function () {
                new yndenz.modules.navigation.search($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });
})(jQuery);

jQuery(function () {
    jQuery('.ym-navbar__search').navigationSearch();
});